/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.document.builder.component;

import java.util.List;
import mod.fuji.core.document.descriptor.PlaceholderDescriptor;
import mod.fuji.core.document.descriptor.StringDescriptor;
import mod.fuji.module.initializer.document.builder.component.DocumentBuilder;
import mod.fuji.module.initializer.document.builder.context.DocumentBuilderContext;
import mod.fuji.module.initializer.document.formatter.MarkdownDocumentFormatter;
import org.jetbrains.annotations.NotNull;

public class ModulePlaceholdersDocumentBuilder
extends DocumentBuilder {
    @Override
    public void build(@NotNull DocumentBuilderContext documentBuilderContext) {
        List<StringDescriptor> placeholders = PlaceholderDescriptor.getPlaceholderDescriptors().stream().filter(it -> it.getSourceModule().equals(documentBuilderContext.getModulePathString())).toList();
        if (!placeholders.isEmpty()) {
            documentBuilderContext.getDocumentBuilder().append("## Placeholders").append(System.lineSeparator());
            placeholders.forEach(it -> this.build(documentBuilderContext, (StringDescriptor)it));
        }
    }

    private void build(@NotNull DocumentBuilderContext documentBuilderContext, StringDescriptor placeholder) {
        String placeholderDocumentString = placeholder.getDocumentString(null).trim();
        placeholderDocumentString = MarkdownDocumentFormatter.parseDocumentString(placeholderDocumentString);
        documentBuilderContext.getDocumentBuilder().append(":::placeholder").append(System.lineSeparator()).append("- Placeholder Name: `%s`".formatted(placeholder.toNameString())).append(System.lineSeparator()).append("- Document: %s".formatted(placeholderDocumentString)).append(System.lineSeparator()).append(":::").append(System.lineSeparator());
    }
}

