/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.auxiliary.minecraft;

import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.ServerHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2556;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class RegistryHelper {
    @NotNull
    public static String getIdAsString(@NotNull class_2960 identifier) {
        return identifier.toString();
    }

    @NotNull
    public static String getIdAsString(@NotNull class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item).toString();
    }

    @NotNull
    public static String getIdAsString(@NotNull class_1799 itemStack) {
        return RegistryHelper.getIdAsString(itemStack.method_7909());
    }

    @NotNull
    public static String getIdAsString(@NotNull class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block).toString();
    }

    @NotNull
    public static String getIdAsString(@NotNull class_2680 blockState) {
        return RegistryHelper.getIdAsString(blockState.method_26204());
    }

    @NotNull
    public static String getIdAsString(@NotNull class_1297 entity) {
        return class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
    }

    @NotNull
    public static String getIdAsString(@NotNull class_1937 world) {
        return RegistryHelper.getIdAsString(world.method_27983());
    }

    @NotNull
    public static String getIdAsString(@NotNull class_5321<?> registryKey) {
        return registryKey.method_29177().toString();
    }

    @NotNull
    public static <T> String getIdAsString(@NotNull class_6880<T> registryEntry) {
        return registryEntry.method_40230().map(RegistryHelper::getIdAsString).orElse("[unregistered]");
    }

    public static String getIdAsString(@NotNull class_2556.class_7602 parameters) {
        String messageTypeIdString = parameters.comp_919().method_55840();
        return messageTypeIdString;
    }

    public static class_5455.class_6890 getCombinedRegistryManager() {
        return ServerHelper.getServer().method_46221().method_45926();
    }

    public static class_7225.class_7874 getDefaultWrapperLookup() {
        return RegistryHelper.getCombinedRegistryManager();
    }

    public static <T> class_2378<T> getRegistry(@NotNull class_5321<? extends class_2378<? extends T>> registryKey) {
        return RegistryHelper.getCombinedRegistryManager().method_30530(registryKey);
    }

    public static <T> class_7871<T> getRegistryEntryLookup(@NotNull class_5321<? extends class_2378<? extends T>> registryKey) {
        return RegistryHelper.getCombinedRegistryManager().method_46762(registryKey);
    }

    public static <T> class_5321<T> ofRegistryKey(@NotNull class_5321<? extends class_2378<T>> registrySpecifier, @NotNull class_2960 identifier) {
        return class_5321.method_29179(registrySpecifier, (class_2960)identifier);
    }

    public static <T> Optional<class_6880<T>> getRegistryEntry(@NotNull class_5321<? extends class_2378<T>> registrySpecifier, @NotNull class_2960 identifier) {
        class_2378<T> registry = RegistryHelper.getRegistry(registrySpecifier);
        Object object = registry.method_10223(identifier);
        class_6880 entry = registry.method_47983(object);
        return Optional.ofNullable(entry);
    }

    @NotNull
    public static class_2960 makeIdentifierOrThrow(@NotNull String identifier) {
        return new class_2960(identifier);
    }

    public static Optional<class_2960> makeIdentifier(@NotNull String identifier) {
        try {
            return Optional.of(RegistryHelper.makeIdentifierOrThrow(identifier));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> Optional<class_5321<T>> findRegistryKey(@NotNull class_5321<? extends class_2378<? extends T>> registrySpecifier, @NotNull T registryValue) {
        return RegistryHelper.getRegistry(registrySpecifier).method_40270().filter(registryEntry -> registryValue.equals(registryEntry.field_36453)).findFirst().flatMap(registryEntry -> {
            Optional key;
            try {
                key = registryEntry.method_40230();
            }
            catch (Exception exceptionIfRegistryEntryHasNoRegistryKey) {
                key = Optional.empty();
            }
            return key;
        });
    }

    public static void ensureIdentifierNamespaceIsFuji(@NotNull class_2960 identifier) {
        if (!identifier.method_12836().equals("fuji")) {
            throw new IllegalArgumentException("The namespace of the identifier must be \"fuji\": " + String.valueOf(identifier));
        }
    }
}

