/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.home.service;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.exception.AbortCommandExecutionException;
import mod.fuji.core.structure.GlobalPos;
import mod.fuji.module.initializer.home.HomeInitializer;
import mod.fuji.module.initializer.home.command.argument.wrapper.HomeName;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class HomeService {
    @NotNull
    public static BiMap<String, GlobalPos> withHomeMap(@NotNull class_3222 player) {
        return HomeService.withHomeMap(PlayerHelper.getPlayerName((class_1657)player));
    }

    @NotNull
    public static BiMap<String, GlobalPos> withHomeMap(@NotNull String playerName) {
        return (BiMap)HomeInitializer.data.model().getName2home().computeIfAbsent(playerName, k -> HashBiMap.create());
    }

    public static Optional<GlobalPos> findHome(@NotNull String playerName, @NotNull String homeName) {
        return Optional.ofNullable((GlobalPos)HomeService.withHomeMap(playerName).get((Object)homeName));
    }

    public static void ensureHomeNameExisting(@NotNull class_3222 player, @NotNull HomeName homeName) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        String homeNameString = (String)homeName.getValue();
        GlobalPos unused = HomeService.findHome(playerName, homeNameString).orElseThrow(() -> {
            TextHelper.sendTextByKey(player, "home.not_found", homeName);
            return new AbortCommandExecutionException();
        });
    }

    public static void renameHome(@NotNull String playerName, @NotNull String oldName, String newName) {
        BiMap<String, GlobalPos> homes = HomeService.withHomeMap(playerName);
        GlobalPos value = (GlobalPos)homes.get((Object)oldName);
        homes.remove((Object)oldName);
        homes.put((Object)newName, (Object)value);
    }

    public static void removeHome(@NotNull String playerName, @NotNull String homeName) {
        BiMap<String, GlobalPos> homes = HomeService.withHomeMap(playerName);
        homes.remove((Object)homeName);
    }
}

