/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.kit.service;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.ReflectionUtil;
import mod.fuji.core.auxiliary.minecraft.GuiHelper;
import mod.fuji.core.auxiliary.minecraft.ItemStackHelper;
import mod.fuji.core.auxiliary.minecraft.NbtHelper;
import mod.fuji.module.initializer.kit.KitInitializer;
import mod.fuji.module.initializer.kit.structure.Kit;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class KitService {
    private static final Path KIT_DATA_DIR_PATH = ReflectionUtil.computeModuleConfigPath(KitInitializer.class).resolve("kit-data");
    private static final String INVENTORY_KEY = "inventory";

    public static void createKitDirectory() {
        Files.createDirectories(KIT_DATA_DIR_PATH, new FileAttribute[0]);
    }

    private static Path getKitPath(String kitName) {
        return KIT_DATA_DIR_PATH.resolve(kitName);
    }

    @NotNull
    public static List<String> listKitNames() {
        List<String> list;
        block8: {
            Stream<Path> list2 = Files.list(KIT_DATA_DIR_PATH);
            try {
                list = list2.map(it -> it.toFile().getName()).toList();
                if (list2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (list2 != null) {
                        try {
                            list2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LogUtil.error("Failed to list kits in storage.", new Object[0]);
                    return Collections.emptyList();
                }
            }
            list2.close();
        }
        return list;
    }

    public static boolean hasKit(String kitName) {
        return Files.exists(KitService.getKitPath(kitName), new LinkOption[0]);
    }

    @NotNull
    public static List<Kit> readKits() {
        return KitService.listKitNames().stream().map(KitService::readKit).collect(Collectors.toList());
    }

    public static void deleteKit(@NotNull String kitName) {
        Files.delete(KitService.getKitPath(kitName));
    }

    public static void createKit(@NotNull Kit kit) {
        NbtHelper.Storage.withNbtFile(KitService.getKitPath(kit.getName()), root -> {
            class_2499 nbtList = new class_2499();
            ItemStackHelper.Codec.writeSlotsNode(nbtList, kit.getStackList());
            LogUtil.debug("createKit: nbtList = {}", nbtList);
            root.method_10566(INVENTORY_KEY, (class_2520)nbtList);
        });
    }

    @NotNull
    public static Kit readKit(@NotNull String kitName) {
        List kitStacks = NbtHelper.Storage.withNbtFile(KitService.getKitPath(kitName), root -> {
            if (root.method_10580(INVENTORY_KEY) == null) {
                root.method_10566(INVENTORY_KEY, (class_2520)new class_2499());
            }
            class_2499 nbtList = (class_2499)root.method_10580(INVENTORY_KEY);
            return ItemStackHelper.Codec.readSlotsNode(nbtList);
        });
        return new Kit(kitName, kitStacks);
    }

    public static void giveKit(class_3222 player, Kit kit) {
        class_1661 playerInventory = player.method_31548();
        ArrayList<class_1799> tryAgainList = new ArrayList<class_1799>();
        for (int i = 0; i < kit.getStackList().size(); ++i) {
            class_1799 template = kit.getStackList().get(i);
            if (template.method_7960() || GuiHelper.Validator.isBannedSlotPlaceholder(template)) continue;
            class_1799 copy = template.method_7972();
            if (playerInventory.method_5438(i).method_7960() && playerInventory.method_7367(i, copy)) continue;
            tryAgainList.add(copy);
        }
        tryAgainList.removeIf(arg_0 -> ((class_1661)playerInventory).method_7394(arg_0));
        tryAgainList.forEach(it -> player.method_7328(it, true));
    }
}

