/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.maintenance;

import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.DocStringProvider;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.descriptor.PermissionDescriptor;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.server.metadata.ModifyServerMetadataEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.maintenance.config.model.MaintenanceConfigModel;
import mod.fuji.module.initializer.maintenance.service.MaintenanceService;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2926;

@Document(id=1756285767531L, value="This module provides a `maintenance mode`, to prevent players joining the server during maintenance.\n")
public class MaintenanceModuleInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<MaintenanceConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", MaintenanceConfigModel.class);
    @DocStringProvider(id=1756286747383L, value="Joins the server while the server is during `maintenance mode`.\n")
    public static final PermissionDescriptor MAINTENANCE_BYPASS_PERMISSION = new PermissionDescriptor("fuji.maintenance.bypass", 1756286747383L);

    @CommandNode(value="maintenance on")
    @CommandRequirement(level=4)
    private static int $on(@CommandSource class_2168 source) {
        MaintenanceService.setMaintenanceModeStatus(true);
        TextHelper.sendTextByKey(source, "maintenance.on", new Object[0]);
        return 1;
    }

    @CommandNode(value="maintenance off")
    @CommandRequirement(level=4)
    private static int $off(@CommandSource class_2168 source) {
        MaintenanceService.setMaintenanceModeStatus(false);
        TextHelper.sendTextByKey(source, "maintenance.off", new Object[0]);
        return 1;
    }

    @CommandNode(value="maintenance kick-all")
    @CommandRequirement(level=4)
    private static int $kickAll(@CommandSource class_2168 source) {
        PlayerHelper.Lookup.getOnlinePlayers().forEach(player -> {
            if (!MaintenanceService.canJoinNow(player)) {
                MaintenanceService.kickPlayer(player);
            }
        });
        return 1;
    }

    @EventConsumer(consumerPriority=2000)
    private static void modifyMaintenanceMotd(ModifyServerMetadataEvent event) {
        if (!MaintenanceService.getMaintenanceModeStatus()) {
            return;
        }
        class_2926 original = event.getServerMetadata();
        class_2561 text = MaintenanceService.getEffectiveMaintenanceMessageText();
        Optional players = original.comp_1274();
        Optional version = original.comp_1275();
        Optional icon = original.comp_1276();
        class_2926 newValue = new class_2926(text, players, version, icon, original.comp_1277());
        event.setServerMetadata(newValue);
    }
}

