/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.maintenance.service;

import java.util.List;
import mod.fuji.core.auxiliary.RandomUtil;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.executor.CommandExecutor;
import mod.fuji.core.command.executor.structure.ExtendedCommandSource;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerJoinedEvent;
import mod.fuji.module.initializer.maintenance.MaintenanceModuleInitializer;
import mod.fuji.module.initializer.maintenance.config.model.MaintenanceConfigModel;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class MaintenanceService {
    public static boolean getMaintenanceModeStatus() {
        return MaintenanceModuleInitializer.config.model().isMaintenanceModeStatus();
    }

    public static boolean canJoinNow(@NotNull class_3222 player) {
        if (!MaintenanceService.getMaintenanceModeStatus()) {
            return true;
        }
        if (CommandHelper.Requirement.isOperator((class_1657)player)) {
            return true;
        }
        if (CommandHelper.Requirement.isAdmin(player.method_64396())) {
            return true;
        }
        return LuckpermsHelper.hasPermission(player.method_5667(), MaintenanceModuleInitializer.MAINTENANCE_BYPASS_PERMISSION, new Object[0]);
    }

    @EventConsumer
    public static void processMaintenanceModeOnPlayerJoined(PlayerJoinedEvent event) {
        class_3222 player = event.getPlayer();
        if (!MaintenanceService.canJoinNow(player)) {
            MaintenanceService.kickPlayer(player);
        }
    }

    public static void kickPlayer(@NotNull class_3222 player) {
        class_2561 reasonText = TextHelper.getTextByKey(player, "maintenance.disconnect", new Object[0]);
        PlayerHelper.disconnectPlayer(player, reasonText);
    }

    public static void setMaintenanceModeStatus(boolean status) {
        MaintenanceModuleInitializer.config.model().setMaintenanceModeStatus(status);
        MaintenanceModuleInitializer.config.writeStorage();
        MaintenanceService.processMaintenanceModeEvents();
    }

    private static void processMaintenanceModeEvents() {
        boolean currentStatus = MaintenanceService.getMaintenanceModeStatus();
        MaintenanceConfigModel.Events events = MaintenanceModuleInitializer.config.model().getEvents();
        List<String> commands = currentStatus ? events.getOnEnterMaintenanceModeCommands() : events.getOnLeaveMaintenanceModeCommands();
        ExtendedCommandSource extendedCommandSource = ExtendedCommandSource.asConsole(CommandHelper.Source.getConsoleCommandSource());
        CommandExecutor.executeBatch(extendedCommandSource, commands);
    }

    public static class_2561 getEffectiveMaintenanceMessageText() {
        String message = RandomUtil.drawList(MaintenanceModuleInitializer.config.model().getMaintenanceMessages());
        return TextHelper.getTextByValue(null, message, new Object[0]);
    }
}

