/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_state;

import java.util.List;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.command_state.CommandStatePlaceholders;
import mod.fuji.module.initializer.command_state.config.model.CommandStateConfigModel;
import mod.fuji.module.initializer.command_state.config.model.CommandStateDataModel;
import mod.fuji.module.initializer.command_state.gui.ListPlayerStatesGui;
import mod.fuji.module.initializer.command_state.service.CommandStateService;
import mod.fuji.module.initializer.command_state.structure.StateDescriptor;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1756692824395L, value="This module allows defining a `state` using `predicate commands`.\nUsing this defined `state`, you can:\n- Define commands to be executed when a player `enters` or `leaves` this `state`.\n- Check whether a player is currently in the `state`.\n- Display `placeholders` relevant to the `state`.\n")
@ColorBox(id=1756707949343L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Define a `state` using `predicate commands`.\nA `state` is composed by `predicate commands`.\n\nYou can define a `state` called `has-iron-and-gold`, with the following `predicate commands`:\n1. `has-item? %player:name% minecraft:iron_ingot 16`\n2. `has-item? %player:name% minecraft:gold_ingot 8`\n\n\u25c9 Integrate with `luckperms`'s `temporary permission`.\nAssign a `temporary permission` using `/lp group default permission settemp fuji.permission.fly true 10s`\n\nThen define a `state` to check whether a player `has specified temporary permission`.\nThis `state` can be called `can-use-fly-command` with the following `predicate commands`:\n1. `has-perm? %player:name% fuji.permission.fly`\n\nLast, you can define `commands to be executed` when a player `leave this state`.\nFor example, define commands to `turn off the flying` while the player `leaves` the `state`.\n\n\u25c9 Check the value of a `state` of a player.\nIssue: `/command-state info Steve`\n\nBesides that, the `/is-in-state? \\<player\\> \\<state-id\\>` can be used as a `predicate command`.\n")
@CommandRequirement(level=4)
public class CommandStateInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandStateConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", CommandStateConfigModel.class);
    public static final BaseConfigurationHandler<CommandStateDataModel> data = ObjectConfigurationHandler.ofModule("command-state-data.json", CommandStateDataModel.class).enableAutoSaveFeature();

    @CommandNode(value="command-state list")
    @Document(id=1756695958335L, value="List all defined `states`.")
    private static int $list(@CommandSource class_2168 source) {
        List<String> ids = CommandStateService.listStateIds();
        TextHelper.sendTextByKey(source, "command_state.list", ids);
        return 1;
    }

    @CommandNode(value="command-state update")
    @Document(id=1756695727818L, value="Update the specified `state` for online players.")
    private static int $update(@CommandSource class_2168 source, StateDescriptor state) {
        CommandStateService.updateCommandState(state);
        return 1;
    }

    @CommandNode(value="command-state update-all")
    @Document(id=1756695744117L, value="Update all defined `states` for online players.")
    private static int $updateAll(@CommandSource class_2168 source) {
        CommandStateService.updateAllCommandStates();
        return 1;
    }

    @CommandNode(value="command-state info")
    @Document(id=1756695758012L, value="Display the value of all `states` of the specified player.")
    private static int $info(@CommandSource class_3222 source, class_3222 player) {
        ListPlayerStatesGui.make(source, player).open();
        return 1;
    }

    @CommandNode(value="is-in-state?")
    @Document(id=1756695870856L, value="Returns whether the specified `state` value for the player is currently `true`.")
    private static int $isInState(@CommandSource class_2168 source, class_3222 player, StateDescriptor state) {
        boolean inState = CommandStateService.checkCurrentStateValue(player, state);
        return CommandHelper.Return.returnBoolean(source, inState);
    }

    @Override
    protected void registerPlaceholders() {
        CommandStatePlaceholders.registerIsInStatePlaceholder();
    }
}

