/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.warning;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import mod.fuji.core.auxiliary.ChronosUtil;
import mod.fuji.core.auxiliary.minecraft.PlaceholderHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.document.annotation.DocStringProvider;
import mod.fuji.core.document.descriptor.PlaceholderDescriptor;
import mod.fuji.module.initializer.warning.service.WarningService;
import mod.fuji.module.initializer.warning.structure.Warning;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class WarningPlaceholders {
    @DocStringProvider(id=1754640787907L, value="Returns the `created date` of the last created warning.")
    public static void registerLastWarningCreatedDatePlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("last_warning_created_date", 1754640787907L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> WarningPlaceholders.mapWarningIntoText(player, it -> class_2561.method_30163((String)ChronosUtil.Formatter.formatDate(it.getCreatedTimestamp()))));
    }

    @DocStringProvider(id=1754641490973L, value="Returns the `creator name` of the last created warning.")
    public static void registerLastWarningCreatorNamePlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("last_warning_creator_name", 1754641490973L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> WarningPlaceholders.mapWarningIntoText(player, it -> class_2561.method_30163((String)it.getCreatorName())));
    }

    @DocStringProvider(id=1754641445726L, value="Returns the `expiration date` of the last created warning.")
    public static void registerLastWarningExpirationDatePlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("last_warning_expiration_date", 1754641445726L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> WarningPlaceholders.mapWarningIntoText(player, it -> class_2561.method_30163((String)ChronosUtil.Formatter.formatDate(it.getExpirationTimestamp()))));
    }

    @DocStringProvider(id=1754641570588L, value="Returns the `reason` of the last created warning.")
    public static void registerLastWarningReasonPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("last_warning_reason", 1754641570588L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> WarningPlaceholders.mapWarningIntoText(player, it -> class_2561.method_30163((String)it.getDescription())));
    }

    @NotNull
    private static class_2561 mapWarningIntoText(class_3222 player, Function<Warning, class_2561> mapper) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        Optional<Warning> first = WarningService.getPlayerWarnings(playerName).getWarnings().stream().max(Comparator.comparing(Warning::getCreatedTimestamp));
        return first.map(mapper).orElseGet(() -> TextHelper.getTextByKey(player, "entity.none", new Object[0]));
    }
}

