/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class RandomUtil {
    private static final Random random = new Random();

    public static <T> T drawList(@NotNull List<T> list) {
        return list.get(random.nextInt(list.size()));
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static int getRandomNumberExclusive(int minInclusive, int maxExclusive) {
        if (minInclusive >= maxExclusive) {
            LogUtil.error("The min value {} must be less than the max value {}. Returning the minimal value as the random number.", minInclusive, maxExclusive);
            return Math.min(minInclusive, maxExclusive);
        }
        return random.nextInt(minInclusive, maxExclusive);
    }

    public static int getRandomNumber(int minInclusive, int maxInclusive) {
        return RandomUtil.getRandomNumberExclusive(minInclusive, maxInclusive + 1);
    }
}

