/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class StringUtil {
    public static final String SPACE = " ";

    public static String replaceAllAndResetMatcher(@NotNull Matcher matcher, @NotNull String replacement) {
        replacement = matcher.replaceAll(replacement);
        matcher.reset();
        return replacement;
    }

    @NotNull
    public static String trimPathString(@NotNull String path) {
        return StringUtils.strip((String)path, (String)".");
    }

    @NotNull
    public static String formatBytes(long bytes) {
        if (bytes == -1L) {
            return "N/A";
        }
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.2fK", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2fM", (double)bytes / 1048576.0);
        }
        return String.format("%.2fG", (double)bytes / 1.073741824E9);
    }

    @NotNull
    public static String toLowerCase(@NotNull String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    @NotNull
    public static String toUpperCase(@NotNull String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static boolean containsIgnoreCase(@NotNull String string, @NotNull String keyword) {
        return StringUtil.toLowerCase(string).contains(StringUtil.toLowerCase(keyword));
    }

    public static int levenshteinDistance(String str1, String str2) {
        int lenStr1 = str1.length();
        int lenStr2 = str2.length();
        int[][] dp = new int[lenStr1 + 1][lenStr2 + 1];
        for (int i = 0; i <= lenStr1; ++i) {
            for (int j = 0; j <= lenStr2; ++j) {
                dp[i][j] = i == 0 ? j : (j == 0 ? i : Math.min(Math.min(dp[i - 1][j - 1] + (str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1), dp[i - 1][j] + 1), dp[i][j - 1] + 1));
            }
        }
        return dp[lenStr1][lenStr2];
    }

    public static String copyMatcherAndReplaceFirst(@NotNull Pattern pattern, @NotNull Matcher matcher, @NotNull String replacement) {
        Matcher copyMatcher = pattern.matcher(matcher.group());
        replacement = copyMatcher.replaceFirst(replacement);
        return replacement;
    }
}

