/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.processor.CommandAnnotationProcessor;
import io.github.sakurawald.fuji.core.command.suggestion.CommandSuggestionOptimizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CommandHelper {
    public static final int COMMAND_EXCEPTION_COLOR_INT = 0xFF5F00;

    public static void updateCommandTree() {
        CommandHelper.updateCommandTree(ServerHelper.getServer().method_3734());
    }

    public static void updateCommandTree(@NotNull class_2170 commandManager) {
        if (ServerHelper.getServer() == null) {
            return;
        }
        PlayerHelper.Lookup.getOnlinePlayers().forEach(arg_0 -> ((class_2170)commandManager).method_9241(arg_0));
    }

    @NotNull
    public static CommandDispatcher<class_2168> getCommandDispatcher() {
        return CommandAnnotationProcessor.COMMAND_DISPATCHER;
    }

    @NotNull
    public static class_7157 getCommandRegistryAccess() {
        return CommandAnnotationProcessor.COMMAND_REGISTRY_ACCESS;
    }

    public static class Context {
        public static <T> Optional<T> tryGetArgument(@NotNull CommandContext<?> commandContext, String argumentName, Class<T> clazz) {
            try {
                return Optional.ofNullable(commandContext.getArgument(argumentName, clazz));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
    }

    public static class Pattern {
        public static int withContextPlayer(@NotNull class_2168 source, @NotNull Function<class_3222, Integer> function) {
            class_3222 player = source.method_44023();
            if (player == null) {
                TextHelper.sendTextByKey(source, "command.player_only", new Object[0]);
                return 1;
            }
            return function.apply(player);
        }

        public static int withItemInMainHand(@NotNull class_3222 source, @NotNull Function<class_1799, Integer> consumer) {
            class_2168 commandSource = Source.getCommandSource((class_1297)source);
            return Pattern.withItemInMainHand(commandSource, (class_3222 player, class_1799 item) -> (Integer)consumer.apply((class_1799)item));
        }

        public static int withItemInMainHand(@NotNull class_2168 source, @NotNull BiFunction<class_3222, class_1799, Integer> consumer) {
            return Pattern.withContextPlayer(source, player -> {
                class_1799 mainHandStack = player.method_6047();
                if (mainHandStack.method_7960()) {
                    TextHelper.sendTextByKey(player, "item.empty.not_allow", new Object[0]);
                    return 0;
                }
                return (Integer)consumer.apply((class_3222)player, mainHandStack);
            });
        }

        public static int withCommandConfirmed(class_3222 player, Optional<Boolean> confirm, Supplier<Integer> supplier) {
            return Pattern.withCommandConfirmed(player.method_64396(), confirm, supplier);
        }

        public static int withCommandConfirmed(class_2168 source, Optional<Boolean> confirm, Supplier<Integer> supplier) {
            boolean confirmed = confirm.orElse(false);
            if (!confirmed) {
                TextHelper.sendTextByKey(source, "operation.confirm.failed", new Object[0]);
                return 0;
            }
            int commandReturnValue = supplier.get();
            return commandReturnValue;
        }
    }

    public static class Suggestion {
        @NotNull
        private static <T> CompletableFuture<Suggestions> makeSuggestionsCompletableFuture(@NotNull SuggestionsBuilder builder, @NotNull Supplier<Iterable<T>> iterableSupplier) {
            Iterable<T> iterable = iterableSupplier.get();
            CommandSuggestionOptimizer.optimize(iterable, builder.getRemaining()).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }

        @NotNull
        public static <T> SuggestionProvider<class_2168> iterable(@NotNull BiFunction<CommandContext<class_2168>, SuggestionsBuilder, Iterable<T>> iterableSupplier) {
            return (context, builder) -> Suggestion.makeSuggestionsCompletableFuture(builder, () -> (Iterable)iterableSupplier.apply(context, builder));
        }

        @NotNull
        public static <T> SuggestionProvider<class_2168> iterable(@NotNull Supplier<Iterable<T>> iterableSupplier) {
            return (context, builder) -> Suggestion.makeSuggestionsCompletableFuture(builder, iterableSupplier);
        }

        @NotNull
        public static <T> SuggestionProvider<class_2168> enums(@NotNull Supplier<T[]> enumValuesSupplier) {
            return Suggestion.iterable(() -> Arrays.asList((Object[])enumValuesSupplier.get()));
        }

        @NotNull
        public static <T> SuggestionProvider<class_2168> identifiers(@NotNull class_5321<? extends class_2378<T>> registryKey) {
            return Suggestion.iterable(() -> RegistryHelper.getRegistry(registryKey).method_10235());
        }
    }

    public static class Return {
        public static final int FAILURE = 0;
        public static final int SUCCESS = 1;

        private static int fromBoolean(boolean value) {
            return value ? 1 : 0;
        }

        public static int returnBoolean(class_2168 source, boolean value) {
            return Return.fromBoolean(value);
        }

        public static boolean isSuccess(int commandReturnValue) {
            return commandReturnValue > 0;
        }
    }

    public static class Source {
        @NotNull
        public static class_2168 getConsoleCommandSource() {
            return ServerHelper.getServer().method_3739();
        }

        @NotNull
        public static class_2168 getCommandSource(@NotNull class_1297 entity) {
            return entity.method_5671((class_3218)entity.method_37908());
        }

        public static void withServerPlayerEntity(@NotNull CommandContextBuilder<class_2168> contextBuilder, @NotNull Consumer<class_3222> consumer) {
            Source.withServerPlayerEntity((class_2168)contextBuilder.getSource(), consumer);
        }

        public static void withServerPlayerEntity(@NotNull CommandContext<?> context, @NotNull Consumer<class_3222> consumer) {
            Object source = context.getSource();
            if (source instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)source;
                Source.withServerPlayerEntity(serverCommandSource, consumer);
                return;
            }
        }

        public static void withServerPlayerEntity(@NotNull class_2168 serverCommandSource, @NotNull Consumer<class_3222> consumer) {
            if (serverCommandSource.method_44023() != null) {
                consumer.accept(serverCommandSource.method_44023());
            }
        }

        public static void withServerCommandSource(@NotNull Object indicator, @NotNull Consumer<class_2168> consumer) {
            if (Source.isServerCommandSource(indicator = Source.extractCommandSource(indicator))) {
                @NotNull class_2168 serverCommandSource = (class_2168)indicator;
                consumer.accept(serverCommandSource);
            }
        }

        public static void withServerCommandSource(@NotNull Object indicator, @NotNull Runnable runnable) {
            Source.withServerCommandSource(indicator, (class_2168 serverCommandSource) -> runnable.run());
        }

        public static <S> boolean isExecutedOnServerSide(@NotNull CommandContextBuilder<S> context) {
            return Source.isExecutedOnServerSide(context.getSource());
        }

        public static boolean isExecutedOnServerSide(@NotNull Object indicator) {
            indicator = Source.extractCommandSource(indicator);
            return Source.isServerCommandSource(indicator);
        }

        public static boolean isExecutedByConsole(@NotNull CommandContext<class_2168> commandContext) {
            return Source.isExecutedByConsole((class_2168)commandContext.getSource());
        }

        public static boolean isExecutedByConsole(@NotNull class_2168 commandSource) {
            return !Source.isExecutedByPlayer(commandSource);
        }

        public static boolean isExecutedByPlayer(@NotNull class_2168 commandSource) {
            return commandSource.method_44023() != null;
        }

        public static boolean isSilent(@NotNull class_2168 commandSource) {
            return commandSource.field_9823;
        }

        private static boolean isServerCommandSource(@NotNull Object object) {
            return object instanceof class_2168;
        }

        @NotNull
        private static Object extractCommandSource(@NotNull Object object) {
            if (object instanceof CommandContext) {
                CommandContext commandContext = (CommandContext)object;
                object = commandContext.getSource();
            }
            if (object instanceof CommandContextBuilder) {
                CommandContextBuilder commandContextBuilder = (CommandContextBuilder)object;
                object = commandContextBuilder.getSource();
            }
            return object;
        }
    }

    public static class Requirement {
        public static boolean canUseThisCommand(class_3222 player, String commandString) {
            class_2168 commandSource = player.method_64396();
            ParseResults parseResults = CommandHelper.getCommandDispatcher().parse(commandString, (Object)commandSource);
            CommandContextBuilder context = parseResults.getContext();
            if (!parseResults.getExceptions().isEmpty()) {
                return false;
            }
            List nodes = context.getNodes();
            if (nodes.isEmpty()) {
                return false;
            }
            return nodes.stream().map(ParsedCommandNode::getNode).allMatch(it -> it.canUse((Object)commandSource));
        }

        public static boolean isOperator(@NotNull class_1657 player) {
            return ServerHelper.getServer().method_3760().method_14569(player.method_7334());
        }

        public static boolean isAdmin(@NotNull class_2168 source) {
            return source.method_9259(4);
        }
    }

    public static class Node {
        @NotNull
        public static String findCommandNodePath(@NotNull CommandNode<class_2168> node) {
            CommandDispatcher<class_2168> dispatcher = CommandHelper.getCommandDispatcher();
            CharSequence[] array = dispatcher.getPath(node).toArray(new String[0]);
            return String.join((CharSequence)".", array);
        }

        @NotNull
        public static String trimCommandPathString(@NotNull String path) {
            return StringUtils.strip((String)path, (String)".");
        }

        @NotNull
        public static String joinCommandNodePath(@NotNull List<ParsedCommandNode<class_2168>> nodes) {
            return nodes.stream().map(it -> it.getNode().getName()).collect(Collectors.joining("."));
        }

        public static List<CommandNode<class_2168>> getAllCommandNodes() {
            ArrayList<CommandNode<class_2168>> result = new ArrayList<CommandNode<class_2168>>();
            CommandDispatcher<class_2168> commandDispatcher = CommandHelper.getCommandDispatcher();
            assert (commandDispatcher != null);
            RootCommandNode root = commandDispatcher.getRoot();
            Node.collectCommandNodes(result, (CommandNode<class_2168>)root);
            return result;
        }

        private static void collectCommandNodes(@NotNull List<CommandNode<class_2168>> collector, @NotNull CommandNode<class_2168> parent) {
            parent.getChildren().forEach(it -> Node.collectCommandNodes(collector, (CommandNode<class_2168>)it));
            if (Node.isRootCommandNode(parent)) {
                collector.add(parent);
            }
        }

        private static boolean isRootCommandNode(@NotNull CommandNode<class_2168> node) {
            return !node.getName().isEmpty();
        }

        @NotNull
        public static List<String> getPrefixesOfCommandPath(@NotNull List<ParsedCommandNode<class_2168>> nodes) {
            ArrayList<String> prefixes = new ArrayList<String>();
            Object walkingPath = "";
            for (ParsedCommandNode<class_2168> node : nodes) {
                String currentNodeName = node.getNode().getName();
                walkingPath = (String)walkingPath + "." + currentNodeName;
                walkingPath = Node.trimCommandPathString((String)walkingPath);
                prefixes.add((String)walkingPath);
            }
            return prefixes;
        }

        public static String getCommandNodeType(@NotNull CommandNode<class_2168> node) {
            if (node instanceof LiteralCommandNode) {
                return "LiteralCommandNode";
            }
            if (node instanceof ArgumentCommandNode) {
                return "ArgumentCommandNode";
            }
            if (node instanceof RootCommandNode) {
                return "RootCommandNode";
            }
            return "Unknown";
        }

        public static Optional<CommandNode<class_2168>> findCommandNode(@NotNull String commandPath) {
            List<String> splitCommandPath = Node.splitCommandPath(commandPath);
            return Optional.ofNullable(CommandHelper.getCommandDispatcher().findNode(splitCommandPath));
        }

        @NotNull
        private static List<String> splitCommandPath(@NotNull String commandPath) {
            String[] nodeNames = commandPath.split("\\.", -1);
            List<String> list = Arrays.asList(nodeNames);
            return list;
        }
    }
}

