/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.StringUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.NbtHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackHelper {
    public static boolean canCombine(@NotNull class_1799 a, @NotNull class_1799 b) {
        if (!a.method_31574(b.method_7909())) {
            return false;
        }
        if (a.method_7960() && b.method_7960()) {
            return true;
        }
        return Objects.equals(CustomData.getCustomDataNbt(a), CustomData.getCustomDataNbt(b));
    }

    public static class CustomData {
        public static void withCustomDataNbt(@NotNull class_1799 stack, @NotNull Consumer<class_2487> nbtConsumer) {
            class_2487 customDataNbt = CustomData.getCustomDataNbt(stack);
            if (customDataNbt == null) {
                customDataNbt = new class_2487();
            }
            nbtConsumer.accept(customDataNbt);
            CustomData.setCustomDataNbt(stack, customDataNbt);
        }

        @Nullable
        public static class_2487 getCustomDataNbt(@NotNull class_1799 stack) {
            class_9279 nbtComponent = (class_9279)stack.method_57824(class_9334.field_49628);
            return nbtComponent == null ? null : nbtComponent.method_57461();
        }

        public static void setCustomDataNbt(@NotNull class_1799 stack, @NotNull class_2487 newNbt) {
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)newNbt));
        }
    }

    public static class Codec {
        @NotNull
        private static class_2520 toNbtAllowEmpty(@NotNull class_1799 stack) {
            if (stack.method_7960()) {
                return new class_2487();
            }
            return Codec.toNbt(stack, (class_2520)new class_2487());
        }

        @NotNull
        private static class_1799 fromNbtOrEmpty(@Nullable class_2487 nbtCompound) {
            if (nbtCompound == null || nbtCompound.method_33133()) {
                return class_1799.field_8037;
            }
            return Codec.fromNbt((class_2520)nbtCompound).orElse(class_1799.field_8037);
        }

        public static class_2499 writeSlotsNode(@NotNull class_2499 node, @NotNull List<class_1799> stackList) {
            stackList.forEach(itemStack -> {
                class_2520 nbtAllowEmpty = Codec.toNbtAllowEmpty(itemStack);
                node.add((Object)nbtAllowEmpty);
            });
            return node;
        }

        @NotNull
        public static List<class_1799> readSlotsNode(@Nullable class_2499 node) {
            if (node == null) {
                return new ArrayList<class_1799>();
            }
            ArrayList<class_1799> ret = new ArrayList<class_1799>();
            for (int i = 0; i < node.size(); ++i) {
                class_2487 nbtCompound = NbtHelper.Primitives.getCompound(node, i).orElseGet(() -> {
                    LogUtil.warn("Failed to read an item stack from slots node: nbtList = {}", node);
                    return new class_2487();
                });
                ret.add(Codec.fromNbtOrEmpty(nbtCompound));
            }
            return ret;
        }

        public static class_2520 toNbt(@NotNull class_1799 stack, @NotNull class_2520 nbtElement) {
            if (stack.method_7960()) {
                throw new IllegalStateException("Cannot encode empty ItemStack");
            }
            return (class_2520)class_1799.field_24671.encode((Object)stack, (DynamicOps)RegistryHelper.getDefaultWrapperLookup().method_57093((DynamicOps)class_2509.field_11560), (Object)nbtElement).getOrThrow();
        }

        public static Optional<class_1799> fromNbt(@NotNull class_2520 nbtElement) {
            return class_1799.field_24671.decode((DynamicOps)RegistryHelper.getDefaultWrapperLookup().method_57093((DynamicOps)class_2509.field_11560), (Object)nbtElement).map(Pair::getFirst).resultOrPartial(string -> LogUtil.debug("Failed to decode item: '{}'", string));
        }
    }

    public static class Filter {
        public static boolean filterItemStack(@Nullable class_1799 itemStack, @NotNull String keyword) {
            if (itemStack == null) {
                return false;
            }
            if (itemStack.method_7960()) {
                return false;
            }
            if (Filter.filterItemName(itemStack, keyword)) {
                return true;
            }
            if (Filter.filterItemMaterial(itemStack, keyword)) {
                return true;
            }
            return Filter.filterItemLore(itemStack, keyword);
        }

        private static boolean filterItemMaterial(@NotNull class_1799 itemStack, @NotNull String keyword) {
            String content = RegistryHelper.getIdAsString(itemStack.method_7909());
            return StringUtil.containsIgnoreCase(content, keyword);
        }

        private static boolean filterItemName(@NotNull class_1799 itemStack, @NotNull String keyword) {
            String itemName = TextHelper.Operators.getString(itemStack.method_7964());
            return StringUtil.containsIgnoreCase(itemName, keyword);
        }

        private static boolean filterItemLore(@NotNull class_1799 itemStack, @NotNull String keyword) {
            boolean matched = Lore.getLore(itemStack).stream().anyMatch(text -> {
                String content = TextHelper.Operators.getString(text);
                return StringUtil.containsIgnoreCase(content, keyword);
            });
            return matched;
        }
    }

    public static class Parser {
        @NotNull
        public static class_1799 parseItemStack(@NotNull String itemString) {
            StringReader stringReader = new StringReader(itemString);
            try {
                class_2290 itemStackArgument = class_2287.method_9776((class_7157)CommandHelper.getCommandRegistryAccess()).method_9778(stringReader);
                class_1799 stack = Parser.createItemStack(itemStackArgument);
                return stack;
            }
            catch (CommandSyntaxException e) {
                LogUtil.warn("Failed to parse the item string {} into an ItemStack instance, falling back to minecraft:barrier as the result ItemStack instance.", itemString);
                return class_1802.field_8077.method_7854();
            }
        }

        @NotNull
        public static class_1799 createItemStack(@NotNull class_2290 itemStackArgument) throws CommandSyntaxException {
            return itemStackArgument.method_9781(1, false);
        }
    }

    public static class Lore {
        private static final String DISPLAY_NBT_KEY = "display";
        private static final String LORE_NBT_KEY = "Lore";

        @NotNull
        public static List<class_2561> getLore(@NotNull class_1799 stack) {
            class_9290 loreComponent = (class_9290)stack.method_57824(class_9334.field_49632);
            if (loreComponent == null) {
                return List.of();
            }
            return loreComponent.comp_2400();
        }

        public static void setLore(@NotNull class_1799 stack, @NotNull List<class_2561> texts) {
            class_9290 loreComponent = new class_9290(texts);
            stack.method_57379(class_9334.field_49632, (Object)loreComponent);
        }
    }

    public static class CustomName {
        public static void removeCustomName(@NotNull class_1799 stack) {
            stack.method_57381(class_9334.field_49631);
        }

        public static void setCustomName(@NotNull class_1799 stack, @NotNull class_2561 customName) {
            stack.method_57379(class_9334.field_49631, (Object)customName);
        }

        public static boolean hasCustomName(@NotNull class_1799 stack) {
            return stack.method_57824(class_9334.field_49631) != null;
        }
    }
}

