/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.tag.TagRegistry;
import eu.pb4.placeholders.api.parsers.tag.TextTag;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import eu.pb4.sgui.virtual.inventory.VirtualScreenHandler;
import io.github.sakurawald.fuji.core.auxiliary.JsonUtil;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.auxiliary.StringUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.command.descriptor.CommandDescriptor;
import io.github.sakurawald.fuji.core.command.structure.CommandActor;
import io.github.sakurawald.fuji.core.config.Configs;
import io.github.sakurawald.fuji.core.config.handler.impl.LanguageConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ResourceConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.core.document.auxiliary.DocumentUtil;
import io.github.sakurawald.fuji.core.gui.component.gui.PagedGui;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.core.manager.impl.task.GameTaskManager;
import io.github.sakurawald.fuji.core.manager.impl.task.structure.GameTask;
import io.github.sakurawald.fuji.core.service.toast_sender.ToastSender;
import io.github.sakurawald.fuji.core.structure.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_189;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_7417;
import net.minecraft.class_8824;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextHelper {
    public static final class_2561 TEXT_NEWLINE = class_2561.method_30163((String)"\n");
    public static final class_2561 TEXT_SPACE = class_2561.method_30163((String)" ");
    public static final class_2561 TEXT_EMPTY = class_2561.method_43470((String)"");
    public static final String PRIMARY_COLOR_STRING = "<#FFA1F5>";
    public static final int PRIMARY_COLOR_INT = 16753141;

    @NotNull
    public static class_2561 getText(@NotNull NodeParser parser, @Nullable Object audience, boolean isKey, String keyOrValue, Object ... args) {
        String languageValue;
        String string = languageValue = isKey ? Translator.getLanguageValueByKey(audience, keyOrValue) : keyOrValue;
        if (languageValue == null) {
            LogUtil.warn("The language value is null: parser = {}, audience = {}, isKey = {}, keyOrValue = {}, args = {}", parser, audience, isKey, keyOrValue, args);
            return class_2561.method_43470((String)"The language value is null, see the console.");
        }
        languageValue = TextHelper.formatStringArgs(languageValue, args);
        PlaceholderContext placeholderContext = Parsers.makePlaceholderContext(audience);
        ParserContext parserContext = ParserContext.of((ParserContext.Key)PlaceholderContext.KEY, (Object)placeholderContext);
        languageValue = Fixer.fixParserInput(languageValue);
        return parser.parseText(TextNode.of((String)languageValue), parserContext);
    }

    @NotNull
    private static String formatStringArgs(@NotNull String string, Object ... args) {
        if (args.length > 0) {
            try {
                return String.format(string, args);
            }
            catch (Exception e) {
                LogUtil.error("Failed to format arguments in language value.\nThe language value is `{}`.\nThe arguments are `{}`.\n\nPossible reasons:\n1. There may be a syntax mistake in the language file. (Try fix it, and issue `/fuji reload` to reload the language file)\n2. You have to write `%%` to mean `%` inside the Java Standard String Formatter. (https://docs.oracle.com/javase/8/docs/api/java/util/Formatter.html)\n3. Outdated language value. (The number of args is mis-matched, try delete the old language value, and issue `/fuji reload` to re-generate a new default value.)\n", string, args, e);
            }
        }
        return string;
    }

    @NotNull
    public static class_2561 getTextByKey(@Nullable Object audience, String languageKey, Object ... args) {
        return TextHelper.getText(Parsers.POWERFUL_PARSER, audience, true, languageKey, args);
    }

    @NotNull
    public static class_2561 getTextByValue(@Nullable Object audience, String languageValue, Object ... args) {
        return TextHelper.getText(Parsers.POWERFUL_PARSER, audience, false, languageValue, args);
    }

    public static class_2561 getTextByKeyAndReplaceTheKeyword(@Nullable Object audience, @NotNull String languageKey, @NotNull String keywordName) {
        String keywordKey = "keyword." + keywordName;
        String keywordValue = Translator.getLanguageValueByKey(audience, keywordKey);
        return TextHelper.getTextByKey(audience, languageKey, keywordValue);
    }

    @NotNull
    private static List<class_2561> getTextList(@Nullable Object audience, boolean isKey, String keyOrValue) {
        String languageValue = isKey ? Translator.getLanguageValueByKey(audience, keyOrValue) : keyOrValue;
        return Arrays.stream(TextHelper.splitStringIntoLines(languageValue)).map(line -> TextHelper.getTextByValue(audience, line, new Object[0])).toList();
    }

    private static String[] splitStringIntoLines(String string) {
        return string.split("\n|<newline>");
    }

    @NotNull
    public static List<class_2561> getTextListByKey(@Nullable Object audience, String key) {
        return TextHelper.getTextList(audience, true, key);
    }

    @NotNull
    public static List<class_2561> getTextListByValue(@Nullable Object audience, String value) {
        return TextHelper.getTextList(audience, false, value);
    }

    @NotNull
    public static List<class_2561> getTextListByValue(@Nullable Object audience, List<String> lines) {
        ArrayList<class_2561> textList = new ArrayList<class_2561>();
        lines.forEach(line -> {
            class_2561 lineText = TextHelper.getTextByValue(audience, line, new Object[0]);
            textList.add(lineText);
        });
        return textList;
    }

    public static void sendMessageByText(@NotNull Object audience, @NotNull class_2561 text) {
        TextHelper.sendText(audience, text, Sender.TextLocation.MESSAGE);
    }

    public static void sendToastByText(@NotNull class_3222 player, @NotNull class_1799 icon, @NotNull class_2561 text) {
        ToastSender.sendToast(player, class_189.field_1254, icon, text);
    }

    public static void sendText(@NotNull Object audience, @NotNull class_2561 text, @NotNull Sender.TextLocation textLocation) {
        if (audience instanceof CommandActor) {
            CommandActor commandActor = (CommandActor)audience;
            audience = commandActor.getCommandContext();
        }
        if (audience instanceof CommandContext) {
            CommandContext ctx = (CommandContext)audience;
            audience = ctx.getSource();
        }
        if (CommandDescriptor.stdoutSpecialVariable.get().booleanValue()) {
            LogUtil.debug("Redirect the text sending into the console (Reason: `--stdout=true`): audience = {}, text = {}", audience, text);
            LogUtil.info("\n\u25c9 Stream the text sending to the console (Reason: --stdout=true)\n- Audience = {}\n- TextLocation = {}\n- Text = {}\n", new Object[]{Sender.getAudienceName(audience), textLocation, text});
        }
        if (CommandDescriptor.silentSpecialVariable.get().booleanValue()) {
            LogUtil.debug("Cancel the text sending (Reason: `--silent=true`): audience = {}, text = {}", audience, text);
            return;
        }
        Sender.sendTextToAudience(audience, text, textLocation);
    }

    public static void sendTextByKey(@NotNull Object audience, @NotNull String languageKey, Object ... args) {
        String languageValue = Translator.getLanguageValueByKey(audience, languageKey);
        if (languageValue.startsWith("[suppress-sending]")) {
            LogUtil.debug("Suppress the sending of text: audience = {}, languageKey = {}, args = {}", audience, languageKey, args);
            return;
        }
        Pair<String, Sender.TextLocation> languageInstructionResult = Sender.parseLanguageInstruction(languageValue);
        languageValue = languageInstructionResult.getKey();
        Sender.TextLocation textLocation = languageInstructionResult.getValue();
        class_2561 text = TextHelper.getTextByValue(audience, languageValue, args);
        try {
            TextHelper.sendText(audience, text, textLocation);
        }
        catch (Exception e) {
            String audienceType = audience.getClass().getName();
            LogUtil.error("Failed to send a text to the audience {}.\n\u25c9 Audience Type: {}\n\u25c9 Language Key: {}\n\u25c9 Args: {}\n\u25c9 Language Value: {}\n", audience, audienceType, languageKey, args, languageValue, e);
        }
    }

    public static void sendBroadcastByKey(@NotNull String key, Object ... args) {
        class_2561 text = TextHelper.getTextByKey(null, key, args);
        LogUtil.info(Operators.getString(text), new Object[0]);
        for (class_3222 player : PlayerHelper.Lookup.getOnlinePlayers()) {
            TextHelper.sendTextByKey(player, key, args);
        }
    }

    public static void sendBroadcastByText(@NotNull class_2561 text) {
        LogUtil.info(Operators.getString(text), new Object[0]);
        for (class_3222 player : PlayerHelper.Lookup.getOnlinePlayers()) {
            TextHelper.sendMessageByText(player, text);
        }
    }

    public static class_2561 getDocumentText(@Nullable Object audience, @NotNull String docString) {
        docString = DocumentUtil.compileDocumentString(docString);
        return TextHelper.getText(Parsers.STYLE_ONLY_PARSER, audience, false, docString, new Object[0]);
    }

    public static List<class_2561> getDocumentTextList(@Nullable Object audience, @NotNull String docString) {
        return Arrays.stream(TextHelper.splitStringIntoLines(docString)).map(line -> TextHelper.getDocumentText(audience, line)).toList();
    }

    static {
        Loader.writeDefaultLanguageFilesIfAbsent();
    }

    public static class Translator {
        @Nullable
        private static String getLanguageValueFromLanguageJson(@NotNull String languageCode, @NotNull String languageKey) {
            JsonObject languageJson = Loader.getLanguageJsonObject(languageCode);
            String defaultLanguageCode = Loader.getDefaultLanguageCode();
            if (Loader.isUnSupportedLanguageJsonObject(languageJson)) {
                languageCode = defaultLanguageCode;
                languageJson = Loader.getLanguageJsonObject(languageCode);
            }
            if (languageJson.has(languageKey)) {
                return languageJson.get(languageKey).getAsString();
            }
            if (!Loader.isDefaultLanguageCode(languageCode)) {
                LogUtil.warn("There is no language key {} in language code {}. We will fallback to default language code {} for this key.", languageKey, languageCode, defaultLanguageCode);
                return Translator.getLanguageValueFromLanguageJson(defaultLanguageCode, languageKey);
            }
            LogUtil.error("Failed to load the language key {} in the default language code. (default language code = {})", languageKey, defaultLanguageCode);
            return null;
        }

        @NotNull
        public static String getLanguageValueByKey(@Nullable Object audience, @NotNull String languageKey) {
            String languageCode = Loader.getAudienceLanguageCode(audience);
            String languageValue = Translator.getLanguageValueFromLanguageJson(languageCode, languageKey);
            if (languageValue != null) {
                return languageValue;
            }
            String dummyLanguageValue = "<red>(No key `%s` in language `%s`)</red>".formatted(languageKey, languageCode);
            LogUtil.warn("Failed to get language value: language code = {}, language key = {}, audience = {}", languageCode, languageKey, audience);
            return dummyLanguageValue;
        }
    }

    public static class Parsers {
        private static final int THIS_STATIC_VARIABLE_IS_USED_TO_ENSURE_THE_EXTENDED_TAGS_ARE_REGISTERED_BEFORE_CREATING_THE_DEFAULT_PARSER = Parsers.registerExtendedTags();
        public static final NodeParser POWERFUL_PARSER = Parsers.makePowerfulParser();
        public static final NodeParser STYLE_ONLY_PARSER = Parsers.makeStyleOnlyParser();
        public static final NodeParser MINI_MESSAGE_ONLY_PARSER = Parsers.makeMiniMessageOnlyParser();
        public static final NodeParser PLACEHOLDER_ONLY_PARSER = Parsers.makePlaceholderOnlyParser();

        private static NodeParser makeMiniMessageOnlyParser() {
            return NodeParser.builder().quickText().simplifiedTextFormat().build();
        }

        private static NodeParser makeStyleOnlyParser() {
            return NodeParser.builder().quickText().simplifiedTextFormat().markdown().build();
        }

        private static NodeParser makePowerfulParser() {
            return NodeParser.builder().quickText().simplifiedTextFormat().globalPlaceholders().markdown().build();
        }

        private static NodeParser makePlaceholderOnlyParser() {
            return NodeParser.builder().globalPlaceholders().build();
        }

        private static int registerExtendedTags() {
            TagRegistry.registerDefault((TextTag)TextTag.self((String)"newline", (String)"formatting", (boolean)true, (nodes, data, parser) -> new LiteralNode("\n")));
            return 0;
        }

        public static String escapeTags(String string) {
            return string.replace("<", "\\<").replace(">", "\\>").replace("*", "\\*").replace("%", "\\%").replace("\u00a7", "&");
        }

        public static class_2561 parseString(NodeParser parser, String input) {
            return parser.parseNode(input).toText();
        }

        @TestCase(action="Test the parsers in Sign block and Anvil block.", targets={"The `color.sign` and `color.anvil` should work in single-player world, when installed client-side."})
        @NotNull
        private static PlaceholderContext makePlaceholderContext(@Nullable Object audience) {
            PlaceholderContext placeholderContext;
            if (audience instanceof class_2168) {
                audience = ((class_2168)audience).method_44023();
            }
            if (audience instanceof class_1657) {
                class_1657 playerEntity = (class_1657)audience;
                if (!PlayerHelper.isServerPlayer(playerEntity)) {
                    LogUtil.debug("PlayerEntity {} is a client-side player entity, we can't use it to make the context for placeholder parser. (I will just fallback to the server context).", new Object[0]);
                    return PlaceholderContext.of((MinecraftServer)ServerHelper.getServer());
                }
                placeholderContext = PlaceholderContext.of((class_1297)playerEntity);
            } else if (audience instanceof GameProfile) {
                GameProfile gameProfile = (GameProfile)audience;
                placeholderContext = PlaceholderContext.of((GameProfile)gameProfile, (MinecraftServer)ServerHelper.getServer());
            } else {
                placeholderContext = PlaceholderContext.of((MinecraftServer)ServerHelper.getServer());
            }
            return placeholderContext;
        }

        @NotNull
        public static String parsePlaceholderString(@Nullable Object audience, String value) {
            class_2561 text = TextHelper.getText(PLACEHOLDER_ONLY_PARSER, audience, false, value, new Object[0]);
            return Operators.getString(text);
        }
    }

    public static class Fixer {
        @TestCase(action="Issue `/fuji`, and see the `document of afk module`, the `details of run module` and the `details of skin` module.", targets={"The text parser should parse the text properly from the earliest version to the latest version.", "The URL highlighter should work properly.", "Ensure the `</>` doesn't break the style of texts."})
        public static String fixParserInput(@NotNull String input) {
            return input;
        }
    }

    public static class Sender {
        private static final String SUPPRESS_SENDING_STRING_MARKER = "[suppress-sending]";
        private static final String SEND_ACTION_BAR_MARKER = "[send-action-bar]";
        private static final String SEND_MAIN_TITLE_MARKER = "[send-main-title]";
        private static final String SEND_SUB_TITLE_MARKER = "[send-sub-title]";

        private static void sendMessageToServerPlayerEntity(@NotNull class_3222 serverPlayerEntity, @NotNull class_2561 text) {
            if (serverPlayerEntity.field_13987 == null) {
                LogUtil.warn("Failed to send the message to player {}, because its network handler is null. (Is it an dummy offline player entity?): text = {}", serverPlayerEntity, text);
                return;
            }
            serverPlayerEntity.method_7353(text, false);
            Sender.streamMessageToToast(serverPlayerEntity, text);
        }

        private static void streamMessageToToast(@NotNull class_3222 serverPlayerEntity, @NotNull class_2561 text) {
            VirtualScreenHandler virtualScreenHandler;
            SlotGuiInterface slotGuiInterface;
            class_1703 class_17032 = serverPlayerEntity.field_7512;
            if (class_17032 instanceof VirtualScreenHandler && (slotGuiInterface = (virtualScreenHandler = (VirtualScreenHandler)class_17032).getGui()) instanceof PagedGui) {
                PagedGui pagedGui = (PagedGui)slotGuiInterface;
                if (!pagedGui.isStreamMessageIntoToast()) {
                    return;
                }
                GameTask gameTask = new GameTask(3, () -> {}, () -> {}, () -> {
                    if (pagedGui.isOpen() && serverPlayerEntity.field_7512 != null) {
                        class_1799 itemStack = GuiHelper.Button.makeLetterIButton().build().getItemStack();
                        TextHelper.sendToastByText(serverPlayerEntity, itemStack, text);
                    }
                });
                Managers.getGameTaskManager();
                GameTaskManager.submitTask(gameTask);
            }
        }

        private static void sendActionBarToAudience(@NotNull Object audience, @NotNull class_2561 text) {
            if (audience instanceof class_1657) {
                class_1657 playerEntity = (class_1657)audience;
                playerEntity.method_7353(text, true);
                return;
            }
            LogUtil.warn("Don't know how to send an ACTION-BAR to audience {}. (text = {})", audience, text);
            throw new IllegalStateException();
        }

        private static void sendTitleToAudience(@NotNull Object audience, @NotNull class_2561 text, boolean useMainTitle) {
            if (audience instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)audience;
                if (useMainTitle) {
                    Sender.sendTitleToServerPlayerEntity(serverPlayerEntity, text, (class_2561)class_2561.method_43473());
                } else {
                    Sender.sendTitleToServerPlayerEntity(serverPlayerEntity, (class_2561)class_2561.method_43473(), text);
                }
                return;
            }
            LogUtil.warn("Don't know how to send a TITLE to audience {}. (text = {})", audience, text);
            throw new IllegalStateException();
        }

        private static void sendMessageToAudience(@NotNull Object audience, @NotNull class_2561 text) {
            if (audience instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)audience;
                Sender.sendMessageToServerPlayerEntity(serverPlayerEntity, text);
                return;
            }
            if (audience instanceof class_1657) {
                class_1657 playerEntity = (class_1657)audience;
                playerEntity.method_7353(text, false);
                return;
            }
            if (audience instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)audience;
                if (serverCommandSource.method_44023() != null) {
                    class_3222 player = serverCommandSource.method_44023();
                    Sender.sendMessageToServerPlayerEntity(player, text);
                    return;
                }
                serverCommandSource.method_45068(text);
                return;
            }
            LogUtil.warn("Don't know how to send a MESSAGE to audience {}. (text = {})", audience, text);
            throw new IllegalStateException();
        }

        private static void sendTitleToServerPlayerEntity(@NotNull class_3222 player, @NotNull class_2561 mainTitle, @NotNull class_2561 subTitle) {
            Sender.sendTitleToServerPlayerEntity(player, 10, 70, 20, mainTitle, subTitle);
        }

        public static void sendTitleToServerPlayerEntity(@NotNull class_3222 player, int fadeInTicks, int stayTicks, int fadeOutTicks, @NotNull class_2561 mainTitle, @NotNull class_2561 subTitle) {
            player.field_13987.method_14364((class_2596)new class_5905(fadeInTicks, stayTicks, fadeOutTicks));
            player.field_13987.method_14364((class_2596)new class_5904(mainTitle));
            player.field_13987.method_14364((class_2596)new class_5903(subTitle));
        }

        private static void sendTextToAudience(@NotNull Object audience, @NotNull class_2561 text, @Nullable TextLocation textLocation) {
            if (TextLocation.ACTION_BAR == textLocation) {
                Sender.sendActionBarToAudience(audience, text);
            } else if (TextLocation.MAIN_TITLE == textLocation) {
                Sender.sendTitleToAudience(audience, text, true);
            } else if (TextLocation.SUB_TITLE == textLocation) {
                Sender.sendTitleToAudience(audience, text, false);
            } else {
                Sender.sendMessageToAudience(audience, text);
            }
        }

        private static Pair<String, TextLocation> parseLanguageInstruction(@NotNull String string) {
            TextLocation textLocation = TextLocation.MESSAGE;
            if (string.startsWith(SEND_ACTION_BAR_MARKER)) {
                string = string.substring(SEND_ACTION_BAR_MARKER.length());
                textLocation = TextLocation.ACTION_BAR;
            } else if (string.startsWith(SEND_MAIN_TITLE_MARKER)) {
                string = string.substring(SEND_MAIN_TITLE_MARKER.length());
                textLocation = TextLocation.MAIN_TITLE;
            } else if (string.startsWith(SEND_SUB_TITLE_MARKER)) {
                string = string.substring(SEND_SUB_TITLE_MARKER.length());
                textLocation = TextLocation.SUB_TITLE;
            }
            return new Pair<String, TextLocation>(string, textLocation);
        }

        private static String getAudienceName(@Nullable Object audience) {
            if (audience == null) {
                return "[audience is null]";
            }
            if (audience instanceof CommandContext) {
                CommandContext commandContext = (CommandContext)audience;
                audience = commandContext.getSource();
            }
            if (audience instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)audience;
                return serverCommandSource.method_9214();
            }
            return audience.toString();
        }

        public static enum TextLocation {
            MESSAGE,
            ACTION_BAR,
            MAIN_TITLE,
            SUB_TITLE;

        }
    }

    public static class Operators {
        public static String getString(@NotNull class_2561 text) {
            return text.getString();
        }

        @NotNull
        public static class_5250 condenseTextList(@NotNull List<class_2561> textList) {
            class_5250 condensedText = class_2561.method_43473();
            for (int i = 0; i < textList.size(); ++i) {
                condensedText.method_10852(textList.get(i));
                if (i == textList.size() - 1) continue;
                condensedText.method_10852(TEXT_NEWLINE);
            }
            return condensedText;
        }
    }

    public static class Loader {
        public static final Map<String, String> PLAYER_2_LANGUAGE_CODE = new ConcurrentHashMap<String, String>();
        public static final Map<String, JsonObject> LANGUAGE_CODE_2_LANGUAGE_JSON = new ConcurrentHashMap<String, JsonObject>();
        private static final JsonObject UNSUPPORTED_LANGUAGE_MARKER = new JsonObject();

        private static void writeDefaultLanguageFilesIfAbsent() {
            for (String languageFileName : Loader.getLanguageFileNameGraph()) {
                String languageCode = LanguageConfigurationHandler.toLanguageCode(languageFileName);
                Loader.loadResourceConfigurationHandler(languageCode);
            }
        }

        @NotNull
        private static List<String> getLanguageFileNameGraph() {
            return ReflectionUtil.CompileTimeGraph.getCompileTimeTxtGraph("language-graph.txt");
        }

        public static void clearLoadedLanguageJsons() {
            LANGUAGE_CODE_2_LANGUAGE_JSON.clear();
        }

        public static void setPlayerLanguageCode(String playerName, String languageRepresentationUsedByMojang) {
            String unifiedLanguageCode = Loader.unifyLanguageCode(languageRepresentationUsedByMojang);
            PLAYER_2_LANGUAGE_CODE.put(playerName, unifiedLanguageCode);
        }

        private static void loadLanguageJsonIfAbsent(String languageCode) {
            if (LANGUAGE_CODE_2_LANGUAGE_JSON.containsKey(languageCode)) {
                return;
            }
            try {
                ResourceConfigurationHandler languageConfigurationHandler = Loader.loadResourceConfigurationHandler(languageCode);
                JsonObject languageJsonObject = ((JsonObject)languageConfigurationHandler.model()).getAsJsonObject();
                Loader.fixParserInput(languageJsonObject);
                LANGUAGE_CODE_2_LANGUAGE_JSON.put(languageCode, languageJsonObject);
                LogUtil.info("Language {} loaded.", languageCode);
            }
            catch (Exception e) {
                LANGUAGE_CODE_2_LANGUAGE_JSON.put(languageCode, UNSUPPORTED_LANGUAGE_MARKER);
                LogUtil.error("Failed to load language `{}` from storage.", languageCode, e);
            }
        }

        private static void fixParserInput(JsonObject jsonObject) {
            jsonObject.keySet().forEach(key -> {
                String originalValue = jsonObject.get(key).getAsString();
                String newValue = Fixer.fixParserInput(originalValue);
                jsonObject.addProperty(key, newValue);
            });
        }

        @NotNull
        private static ResourceConfigurationHandler loadResourceConfigurationHandler(@NotNull String languageCode) {
            LanguageConfigurationHandler languageFileHandler = new LanguageConfigurationHandler(languageCode);
            languageFileHandler.readStorage();
            return languageFileHandler;
        }

        private static String unifyLanguageCode(String input) {
            if (input == null || !input.contains("_")) {
                return input;
            }
            String[] components = input.split("_");
            String language = StringUtil.toLowerCase(components[0]);
            String region = StringUtil.toUpperCase(components[1]);
            return language + "_" + region;
        }

        @NotNull
        private static String getAudienceLanguageCode(@Nullable Object audience) {
            if (audience == null) {
                return Loader.getDefaultLanguageCode();
            }
            @Nullable class_1657 player = Loader.tryExtractPlayerEntity(audience);
            if (player == null) {
                return Loader.getDefaultLanguageCode();
            }
            String playerName = PlayerHelper.getPlayerName(player);
            String defaultLanguageCode = Loader.getDefaultLanguageCode();
            return PLAYER_2_LANGUAGE_CODE.computeIfAbsent(playerName, k -> defaultLanguageCode);
        }

        @Nullable
        private static class_1657 tryExtractPlayerEntity(@NotNull Object audience) {
            class_2168 commandSource;
            class_3222 player = null;
            if (audience instanceof CommandContext) {
                CommandContext commandContext = (CommandContext)audience;
                audience = commandContext.getSource();
            }
            if (audience instanceof class_3222) {
                player = (class_3222)audience;
            } else if (audience instanceof class_1657) {
                player = (class_1657)audience;
            } else if (audience instanceof class_2168 && (commandSource = (class_2168)audience).method_44023() != null) {
                player = commandSource.method_44023();
            }
            return player;
        }

        @NotNull
        private static JsonObject getLanguageJsonObject(String languageCode) {
            Loader.loadLanguageJsonIfAbsent(languageCode);
            return LANGUAGE_CODE_2_LANGUAGE_JSON.get(languageCode);
        }

        private static String getDefaultLanguageCode() {
            return Loader.unifyLanguageCode(Configs.MAIN_CONTROL_CONFIG.model().core.language.default_language);
        }

        public static boolean isDefaultLanguageCode(String languageCode) {
            return languageCode.equals(Loader.getDefaultLanguageCode());
        }

        public static boolean shouldUseBuiltInDocStrings() {
            if (Loader.isUsingEnglishAsTheDefaultLanguage()) {
                return true;
            }
            return Configs.MAIN_CONTROL_CONFIG.model().core.document.alwaysUseBuiltInDocStrings;
        }

        private static boolean isUsingEnglishAsTheDefaultLanguage() {
            return Loader.getDefaultLanguageCode().equalsIgnoreCase("en_US");
        }

        public static boolean isUnSupportedLanguageJsonObject(JsonObject languageJson) {
            return UNSUPPORTED_LANGUAGE_MARKER.equals((Object)languageJson);
        }
    }

    public static class Codec {
        public static String toJson(@NotNull class_2561 text) {
            return ((JsonElement)class_8824.field_46597.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)text).getOrThrow()).toString();
        }

        public static class_2561 fromJson(@NotNull String textJson) {
            return (class_2561)((com.mojang.datafixers.util.Pair)class_8824.field_46597.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonUtil.readJsonString(textJson)).getOrThrow()).getFirst();
        }
    }

    public static class Formatter {
        public static <K, V> class_5250 formatMapMultiLine(Map<K, V> map) {
            return Formatter.formatMap(map, "", "", "\n");
        }

        public static <K, V> class_5250 formatMapInLine(Map<K, V> map) {
            return Formatter.formatMap(map, "{", "}", ", ");
        }

        @NotNull
        private static <K, V> class_5250 formatMap(Map<K, V> map, String prefixString, String suffixString, String splitterString) {
            class_5250 builder = class_2561.method_43473();
            boolean firstElement = true;
            builder.method_10852((class_2561)class_2561.method_43470((String)prefixString));
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (!firstElement) {
                    class_5250 splitterText = class_2561.method_43470((String)splitterString).method_27696(class_2583.field_24360.method_10977(class_124.field_1063));
                    builder.method_10852((class_2561)splitterText);
                }
                firstElement = false;
                class_2561 entryText = TextHelper.getTextByKey(null, "map.entry", entry.getKey(), entry.getValue());
                builder.method_10852(entryText);
            }
            builder.method_10852((class_2561)class_2561.method_43470((String)suffixString));
            return builder;
        }
    }

    public static class Events {

        public static class HoverEvent {
            public static class_2568 makeShowTextAction(@NotNull class_2561 hoverText) {
                return new class_2568(class_2568.class_5247.field_24342, (Object)hoverText);
            }
        }

        public static class ClickEvent {
            public static class_2558 makeSuggestCommandAction(@NotNull String command) {
                return new class_2558(class_2558.class_2559.field_11745, command);
            }

            public static class_2558 makeRunCommandAction(@NotNull String command) {
                return new class_2558(class_2558.class_2559.field_11750, command);
            }

            public static class_2558 makeCopyToClipboardAction(@NotNull String string) {
                return new class_2558(class_2558.class_2559.field_21462, string);
            }
        }
    }

    public static class Replacer {
        public static class_5250 replaceTextWithNamedArgument(@NotNull class_2561 text, @NotNull String namedArgumentName, @NotNull Function<Matcher, class_2561> replacementSupplier) {
            return Replacer.replaceTextWithRegex(text, "\\$\\{%s}".formatted(namedArgumentName), replacementSupplier);
        }

        public static class_5250 replaceTextWithPattern(@NotNull class_2561 text, @NotNull Pattern pattern, @NotNull Function<Matcher, class_2561> nonMemorizedReplacementSupplier) {
            nonMemorizedReplacementSupplier = Replacer.makeMemoizeSupplier(nonMemorizedReplacementSupplier);
            return Replacer.replaceText(text, pattern, nonMemorizedReplacementSupplier);
        }

        public static class_5250 replaceTextWithRegex(@NotNull class_2561 text, @NotNull String regex, @NotNull Function<Matcher, class_2561> nonMemorizedReplacementSupplier) {
            return Replacer.replaceTextWithPattern(text, Pattern.compile(regex), nonMemorizedReplacementSupplier);
        }

        private static class_5250 replaceText(@NotNull class_2561 text, @NotNull Pattern pattern, @NotNull Function<Matcher, class_2561> replacementSupplier) {
            class_5250 replacedText;
            String textString = Replacer.flattenTextContent(text.method_10851());
            @Nullable List<class_2561> splits = Replacer.splitAndReplaceText(textString, pattern, replacementSupplier);
            if (splits == null) {
                replacedText = text.method_27662();
            } else {
                class_5250 dummyRoot;
                replacedText = dummyRoot = class_2561.method_43473();
                splits.forEach(arg_0 -> ((class_5250)dummyRoot).method_10852(arg_0));
            }
            replacedText.method_27696(text.method_10866());
            for (class_2561 sibling : text.method_10855()) {
                class_5250 replacedSibling = Replacer.replaceText(sibling, pattern, replacementSupplier);
                replacedText.method_10852((class_2561)replacedSibling);
            }
            return replacedText;
        }

        @Nullable
        private static List<class_2561> splitAndReplaceText(@NotNull String string, @NotNull Pattern pattern, @NotNull Function<Matcher, class_2561> replacementSupplier) {
            ArrayList<class_2561> result = new ArrayList<class_2561>();
            Matcher matcher = pattern.matcher(string);
            int startIndex = 0;
            while (matcher.find()) {
                int matchedStringIndex = matcher.start();
                if (matchedStringIndex != startIndex) {
                    class_5250 prefixText = class_2561.method_43470((String)string.substring(startIndex, matchedStringIndex));
                    result.add((class_2561)prefixText);
                }
                class_2561 replacementText = replacementSupplier.apply(matcher);
                result.add(replacementText);
                startIndex = matcher.end();
            }
            if (result.isEmpty()) {
                return null;
            }
            if (startIndex < string.length()) {
                class_5250 suffixText = class_2561.method_43470((String)string.substring(startIndex));
                result.add((class_2561)suffixText);
            }
            return result;
        }

        private static <T> Function<Matcher, T> makeMemoizeSupplier(@NotNull Function<Matcher, T> delegate) {
            AtomicReference value = new AtomicReference();
            return matcher -> {
                Object val = value.get();
                if (val == null) {
                    val = value.updateAndGet(cur -> cur == null ? Objects.requireNonNull(delegate.apply((Matcher)matcher)) : cur);
                }
                return val;
            };
        }

        private static String flattenTextContent(@NotNull class_7417 textContent) {
            StringBuilder stringBuilder = new StringBuilder();
            textContent.method_27659(string -> {
                stringBuilder.append(string);
                return Optional.empty();
            });
            return stringBuilder.toString();
        }
    }
}

