/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.command.argument.structure;

import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.annotation.CommandTarget;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyStringList;
import io.github.sakurawald.fuji.core.command.structure.CommandActor;
import io.github.sakurawald.fuji.core.command.structure.CommandRequirementDescriptor;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import java.lang.reflect.Parameter;
import lombok.Generated;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandArgument {
    private static final Class<?> LITERAL_ARGUMENT_TYPE_CLASS = Void.class;
    @NotNull
    private final Class<?> argumentType;
    @NotNull
    private final String argumentName;
    private final boolean isOptional;
    @Nullable
    private CommandRequirementDescriptor requirement;
    private boolean isCommandSource;
    private boolean isCommandTarget;
    @Nullable
    private String document;

    public CommandArgument(@NotNull Class<?> argumentType, @NotNull String argumentName, boolean isOptional, @Nullable CommandRequirementDescriptor requirement) {
        this.argumentType = argumentType;
        this.argumentName = argumentName;
        this.isOptional = isOptional;
        this.requirement = requirement;
    }

    @NotNull
    public static CommandArgument ofRequiredArgument(@NotNull Class<?> typeClass, @NotNull String argumentName, boolean isOptional, @Nullable CommandRequirementDescriptor requirement) {
        return new CommandArgument(typeClass, argumentName, isOptional, requirement);
    }

    @NotNull
    public static CommandArgument ofLiteralArgument(@NotNull String argumentName, @Nullable CommandRequirementDescriptor requirement) {
        return new CommandArgument(LITERAL_ARGUMENT_TYPE_CLASS, argumentName, false, requirement);
    }

    public boolean isRequiredArgument() {
        return !this.isLiteralArgument();
    }

    public boolean isMethodParameterSpecifier() {
        return this.isRequiredArgument();
    }

    public boolean isCommandArgumentSpecifier() {
        if (this.isCommandSource()) {
            return false;
        }
        return !this.getArgumentType().equals(CommandActor.class);
    }

    public boolean isLiteralArgument() {
        return this.argumentType == LITERAL_ARGUMENT_TYPE_CLASS;
    }

    @NotNull
    private String toRequirementString() {
        if (this.requirement == null) {
            return "NONE";
        }
        return "{%d %s}".formatted(this.requirement.getLevel(), this.requirement.getString()).trim();
    }

    public String toString() {
        if (this.isRequiredArgument()) {
            Object flags = "";
            if (this.isCommandSource) {
                flags = (String)flags + "S";
            }
            if (this.isCommandTarget) {
                flags = (String)flags + "T";
            }
            if (this.isOptional) {
                return "[%s %s]{flags=%s req=%s}".formatted(this.argumentType.getSimpleName(), this.argumentName, flags, this.toRequirementString());
            }
            return "<%s %s>{flags=%s req=%s}".formatted(this.argumentType.getSimpleName(), this.argumentName, flags, this.toRequirementString());
        }
        return "%s{req=%s}".formatted(this.argumentName, this.toRequirementString());
    }

    @NotNull
    public String toFriendlyString() {
        if (this.isLiteralArgument()) {
            return this.argumentName;
        }
        String argumentType = this.getArgumentType().getSimpleName();
        if (this.isOptional) {
            return "[%s %s]".formatted(argumentType, this.argumentName);
        }
        return "<%s %s>".formatted(argumentType, this.argumentName);
    }

    @NotNull
    public CommandArgument fillParameter(@NotNull Parameter parameter) {
        this.fillDocument(parameter);
        this.fillCommandSource(parameter);
        this.fillCommandTarget(parameter);
        return this;
    }

    @NotNull
    private CommandArgument fillDocument(@NotNull Parameter parameter) {
        Document document = parameter.getAnnotation(Document.class);
        if (document == null) {
            return this;
        }
        this.document = document.value();
        return this;
    }

    @NotNull
    private CommandArgument fillCommandSource(@NotNull Parameter parameter) {
        if (!parameter.isAnnotationPresent(CommandSource.class)) {
            return this;
        }
        if (!this.isRequiredArgument()) {
            throw new IllegalArgumentException("The argument used as the command source must be a required argument.");
        }
        this.isCommandSource = true;
        return this;
    }

    @NotNull
    private CommandArgument fillCommandTarget(@NotNull Parameter parameter) {
        if (!parameter.isAnnotationPresent(CommandTarget.class)) {
            return this;
        }
        if (!this.isRequiredArgument()) {
            throw new IllegalArgumentException("The argument used as the command target must be a required argument.");
        }
        if (!parameter.getType().equals(class_3222.class)) {
            throw new IllegalArgumentException("The @CommandTarget annotation can only be annotated on the ServerPlayerEntity parameter type: class = %s, method = %s".formatted(parameter.getDeclaringExecutable().getName(), parameter.getDeclaringExecutable().getDeclaringClass().getName()));
        }
        this.isCommandTarget = true;
        return this;
    }

    public boolean isGreedyArgumentType() {
        return this.argumentType.equals(GreedyString.class) || this.argumentType.equals(GreedyStringList.class);
    }

    @NotNull
    @Generated
    public Class<?> getArgumentType() {
        return this.argumentType;
    }

    @NotNull
    @Generated
    public String getArgumentName() {
        return this.argumentName;
    }

    @Generated
    public boolean isOptional() {
        return this.isOptional;
    }

    @Nullable
    @Generated
    public CommandRequirementDescriptor getRequirement() {
        return this.requirement;
    }

    @Generated
    public boolean isCommandSource() {
        return this.isCommandSource;
    }

    @Generated
    public boolean isCommandTarget() {
        return this.isCommandTarget;
    }

    @Nullable
    @Generated
    public String getDocument() {
        return this.document;
    }

    @Generated
    public CommandArgument setRequirement(@Nullable CommandRequirementDescriptor requirement) {
        this.requirement = requirement;
        return this;
    }

    @Generated
    public CommandArgument setCommandSource(boolean isCommandSource) {
        this.isCommandSource = isCommandSource;
        return this;
    }

    @Generated
    public CommandArgument setCommandTarget(boolean isCommandTarget) {
        this.isCommandTarget = isCommandTarget;
        return this;
    }

    @Generated
    public CommandArgument setDocument(@Nullable String document) {
        this.document = document;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandArgument)) {
            return false;
        }
        CommandArgument other = (CommandArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOptional() != other.isOptional()) {
            return false;
        }
        if (this.isCommandSource() != other.isCommandSource()) {
            return false;
        }
        if (this.isCommandTarget() != other.isCommandTarget()) {
            return false;
        }
        Class<?> this$argumentType = this.getArgumentType();
        Class<?> other$argumentType = other.getArgumentType();
        if (this$argumentType == null ? other$argumentType != null : !this$argumentType.equals(other$argumentType)) {
            return false;
        }
        String this$argumentName = this.getArgumentName();
        String other$argumentName = other.getArgumentName();
        if (this$argumentName == null ? other$argumentName != null : !this$argumentName.equals(other$argumentName)) {
            return false;
        }
        CommandRequirementDescriptor this$requirement = this.getRequirement();
        CommandRequirementDescriptor other$requirement = other.getRequirement();
        if (this$requirement == null ? other$requirement != null : !((Object)this$requirement).equals(other$requirement)) {
            return false;
        }
        String this$document = this.getDocument();
        String other$document = other.getDocument();
        return !(this$document == null ? other$document != null : !this$document.equals(other$document));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommandArgument;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOptional() ? 79 : 97);
        result = result * 59 + (this.isCommandSource() ? 79 : 97);
        result = result * 59 + (this.isCommandTarget() ? 79 : 97);
        Class<?> $argumentType = this.getArgumentType();
        result = result * 59 + ($argumentType == null ? 43 : $argumentType.hashCode());
        String $argumentName = this.getArgumentName();
        result = result * 59 + ($argumentName == null ? 43 : $argumentName.hashCode());
        CommandRequirementDescriptor $requirement = this.getRequirement();
        result = result * 59 + ($requirement == null ? 43 : ((Object)$requirement).hashCode());
        String $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        return result;
    }
}

