/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.command.assistant;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.assistant.structure.AvailableNextCommandPath;
import io.github.sakurawald.fuji.core.command.assistant.structure.AvailableNextCommandPathList;
import io.github.sakurawald.fuji.core.config.Configs;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.core.structure.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class CommandAssistant {
    private static final Map<String, AvailableNextCommandPathList> DEBOUNCE_AVAILABLE_NEXT_COMMAND_PATHS = new ConcurrentHashMap<String, AvailableNextCommandPathList>();
    private static final Map<String, String> DEBOUNCE_COMPLETED_COMMAND_PATH = new ConcurrentHashMap<String, String>();

    @NotNull
    private static String toStringByArgumentType(@NotNull CommandNode<class_2168> commandNode) {
        if (commandNode instanceof ArgumentCommandNode) {
            return "<" + commandNode.getName() + ">";
        }
        if (commandNode instanceof LiteralCommandNode) {
            return commandNode.getName();
        }
        return "root";
    }

    private static boolean hasUnparsedCharacters(@NotNull CommandContext<class_2168> commandContext, @NotNull SuggestionsBuilder builder) {
        ParsedCommandNode<class_2168> lastCommandNode = CommandAssistant.getLastParsedCommandNode(commandContext);
        int parsedNodeStart = lastCommandNode.getRange().getStart();
        int suggestionsBuilderStart = builder.getStart();
        return suggestionsBuilderStart != parsedNodeStart;
    }

    private static ParsedCommandNode<class_2168> getLastParsedCommandNode(@NotNull CommandContext<class_2168> commandContext) {
        List parsedCommandNodes = commandContext.getNodes();
        return (ParsedCommandNode)parsedCommandNodes.get(parsedCommandNodes.size() - 1);
    }

    @NotNull
    private static List<CommandContext<class_2168>> makeCommandContextChain(@NotNull CommandContext<class_2168> rootCommandContext) {
        ArrayList<CommandContext<class_2168>> commandContextChain = new ArrayList<CommandContext<class_2168>>();
        CommandContext root = rootCommandContext;
        commandContextChain.add(root);
        while (root.getChild() != null) {
            root = root.getChild();
            commandContextChain.add((CommandContext<class_2168>)root);
        }
        return commandContextChain;
    }

    @NotNull
    private static Pair<CommandContext<class_2168>, CommandNode<class_2168>> getAssistanceTargetCommandNode(@NotNull CommandContext<class_2168> rootCommandContext) {
        List<CommandContext<class_2168>> commandContextChain = CommandAssistant.makeCommandContextChain(rootCommandContext);
        for (int i = commandContextChain.size() - 1; i >= 0; --i) {
            CommandContext<class_2168> currentCommandContext = commandContextChain.get(i);
            List currentParsedCommandNodes = currentCommandContext.getNodes();
            for (int j = currentParsedCommandNodes.size() - 1; j >= 0; --j) {
                ParsedCommandNode candidateParsedCommandNode = (ParsedCommandNode)currentParsedCommandNodes.get(j);
                StringRange range = candidateParsedCommandNode.getRange();
                if (range.getStart() == range.getEnd()) continue;
                return new Pair<CommandContext<class_2168>, CommandNode<class_2168>>(currentCommandContext, candidateParsedCommandNode.getNode());
            }
        }
        LogUtil.warn("Failed to get last parsed command node from command context chain, falling back to the last command nodes of the root command context {}.", commandContextChain);
        return new Pair<CommandContext<class_2168>, CommandNode<class_2168>>(rootCommandContext, CommandAssistant.getLastParsedCommandNode(rootCommandContext).getNode());
    }

    @NotNull
    private static String getParsedCommandPath(@NotNull CommandContext<class_2168> rootCommandContext) {
        StringBuilder sb = new StringBuilder("/");
        List<CommandContext<class_2168>> commandContexts = CommandAssistant.makeCommandContextChain(rootCommandContext);
        commandContexts.forEach(commandContext -> commandContext.getNodes().forEach(parsedCommandNode -> sb.append(CommandAssistant.toStringByArgumentType((CommandNode<class_2168>)parsedCommandNode.getNode())).append(" ")));
        return sb.toString();
    }

    private static void printUsageForCommandNode(@NotNull class_2168 commandSource, @NotNull CommandContext<class_2168> rootCommandContext, @NotNull CommandContext<class_2168> commandContext, @NotNull CommandNode<class_2168> targetCommandNode, @NotNull SuggestionsBuilder builder) {
        AtomicBoolean headerMessagePrinted = new AtomicBoolean(false);
        AvailableNextCommandPathList currentAvailableNextCommandPathList = new AvailableNextCommandPathList();
        String inputString = commandContext.getInput();
        for (String value : CommandHelper.getCommandDispatcher().getSmartUsage(targetCommandNode, (Object)commandSource).values()) {
            String prefixString = inputString.substring(0, builder.getStart());
            String infixString = "...";
            if (!CommandAssistant.hasUnparsedCharacters(commandContext, builder)) {
                infixString = CommandAssistant.toStringByArgumentType((CommandNode<class_2168>)CommandAssistant.getLastParsedCommandNode(commandContext).getNode());
            }
            Object suffixString = " " + value;
            prefixString = prefixString.trim();
            infixString = infixString.trim();
            suffixString = ((String)suffixString).trim();
            currentAvailableNextCommandPathList.getEntries().add(new AvailableNextCommandPath(prefixString, infixString, (String)suffixString));
        }
        DEBOUNCE_AVAILABLE_NEXT_COMMAND_PATHS.compute(commandSource.method_9214(), (key, previousValue) -> {
            if (!currentAvailableNextCommandPathList.equals(previousValue)) {
                DEBOUNCE_COMPLETED_COMMAND_PATH.remove(commandSource.method_9214());
                if (!currentAvailableNextCommandPathList.getEntries().isEmpty()) {
                    CommandAssistant.printCommandAssistantHeaderIfAbsent(headerMessagePrinted, commandSource);
                }
                currentAvailableNextCommandPathList.getEntries().forEach(entry -> {
                    class_2561 possiblePathText = TextHelper.getTextByKey(commandSource, "command.assistant.incomplete", TextHelper.Parsers.escapeTags(entry.getPrefixString()), TextHelper.Parsers.escapeTags(entry.getInfixString()), TextHelper.Parsers.escapeTags(entry.getSuffixString()));
                    commandSource.method_45068(possiblePathText);
                });
            }
            return currentAvailableNextCommandPathList;
        });
        if (CommandAssistant.isCommandNodeExecutable(targetCommandNode)) {
            String currentCompletedCommandPath = CommandAssistant.getParsedCommandPath(rootCommandContext);
            DEBOUNCE_COMPLETED_COMMAND_PATH.compute(commandSource.method_9214(), (key, previousValue) -> {
                if (!currentCompletedCommandPath.equals(previousValue)) {
                    CommandAssistant.printCommandAssistantHeaderIfAbsent(headerMessagePrinted, commandSource);
                    class_2561 text = TextHelper.getTextByKey(commandSource, "command.assistant.complete", TextHelper.Parsers.escapeTags(currentCompletedCommandPath));
                    commandSource.method_45068(text);
                }
                return currentCompletedCommandPath;
            });
        }
    }

    private static void printCommandAssistantHeaderIfAbsent(@NotNull AtomicBoolean headerPrinted, @NotNull class_2168 commandSource) {
        if (headerPrinted.compareAndSet(false, true)) {
            class_2561 headerText = TextHelper.getTextByKey(commandSource, "command.assistant.header", new Object[0]);
            commandSource.method_45068(headerText);
        }
    }

    private static boolean isCommandNodeExecutable(@NotNull CommandNode<class_2168> targetCommandNode) {
        return targetCommandNode.getCommand() != null;
    }

    @TestCase(action="Test the command assistant.", targets={"Change the `cursor` using mouse click, and see the output.", "Test the assistant with command redirect", "Test the assistant at the beginning of the token", "Test the assistant at the end of the token", "Test the assistant with the optional argument: `/back 3`", "Test the assistant with the entity selector: `/send-message @r`", "Test the assistant with custom parser and non-zero-offset suggestions builder: `/fly others @a[distance=..8`"})
    public static void assist(@NotNull CommandContext<class_2168> rootCommandContext, @NotNull SuggestionsBuilder builder) {
        if (CommandAssistant.canUseCommandAssistant(rootCommandContext)) {
            return;
        }
        Pair<CommandContext<class_2168>, CommandNode<class_2168>> pair = CommandAssistant.getAssistanceTargetCommandNode(rootCommandContext);
        CommandContext<class_2168> targetCommandContext = pair.getKey();
        CommandNode<class_2168> targetCommandNode = pair.getValue();
        targetCommandNode = CommandAssistant.performForwardAction(targetCommandNode);
        class_2168 source = (class_2168)rootCommandContext.getSource();
        CommandAssistant.printUsageForCommandNode(source, rootCommandContext, targetCommandContext, targetCommandNode, builder);
    }

    @NotNull
    private static CommandNode<class_2168> performForwardAction(CommandNode<class_2168> targetCommandNode) {
        CommandNode redirectTargetCommandNode = targetCommandNode.getRedirect();
        if (redirectTargetCommandNode != null) {
            targetCommandNode = redirectTargetCommandNode;
        }
        return targetCommandNode;
    }

    private static boolean canUseCommandAssistant(@NotNull CommandContext<class_2168> rootCommandContext) {
        return !((class_2168)rootCommandContext.getSource()).method_9259(Configs.MAIN_CONTROL_CONFIG.model().core.command.assistant.requirement.level_permission);
    }

    public static class Inspector {
        public static void inspectCommandContext(@NotNull CommandContext<class_2168> commandContext, @NotNull String walkingPath) {
            LogUtil.info("\u001b[34m\u25c9 Inspect command context {} (path = {})", commandContext, walkingPath);
            LogUtil.info("input string = '{}'", commandContext.getInput());
            LogUtil.info("input string range = {}", commandContext.getRange());
            LogUtil.info("command action = {}", commandContext.getCommand());
            LogUtil.info("root command node = {}", commandContext.getRootNode());
            LogUtil.info("parsed command nodes = {}", commandContext.getNodes());
            LogUtil.info("child command context = {}", commandContext.getChild());
            if (commandContext.getChild() != null) {
                Inspector.inspectCommandContext((CommandContext<class_2168>)commandContext.getChild(), walkingPath + ".child");
            }
        }

        private static void inspectSuggestionsBuilder(@NotNull SuggestionsBuilder builder) {
            LogUtil.info("\u001b[35m\u25c9 Inspect suggestions builder {}", builder);
            LogUtil.info("input string = '{}'", builder.getInput());
            LogUtil.info("remaining string = '{}'", builder.getRemaining());
            LogUtil.info("start = {}", builder.getStart());
        }

        private static void inspectCommandNode(@NotNull CommandNode<class_2168> commandNode) {
            LogUtil.info("\u001b[32m\u25c9 Inspect command node {}", commandNode);
            LogUtil.info("name = {}", commandNode.getName());
            LogUtil.info("command action = {}", commandNode.getCommand());
            LogUtil.info("redirect command node = {}", commandNode.getRedirect());
            LogUtil.info("is fork = {}", commandNode.isFork());
            LogUtil.info("children command nodes = {}", commandNode.getChildren());
        }
    }
}

