/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.command.descriptor;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.command.argument.structure.CommandArgument;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.PlayerCollection;
import io.github.sakurawald.fuji.core.command.descriptor.CommandDescriptor;
import io.github.sakurawald.fuji.core.command.structure.CommandRequirementDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class RetargetCommandDescriptor
extends CommandDescriptor {
    public static final String OTHERS_LITERAL = "others";
    private final int commandSourceParameterIndex;
    private final int commandTargetParameterIndex;
    private final int othersParameterIndex;

    private RetargetCommandDescriptor(@NotNull CommandDescriptor baseCommandDescriptor) {
        super(baseCommandDescriptor.method, RetargetCommandDescriptor.makeRetargetCommandArguments(baseCommandDescriptor));
        this.commandTargetParameterIndex = baseCommandDescriptor.findCommandTargetMethodParameterSpecifierIndex().orElseThrow(() -> new IllegalArgumentException("Failed to find the command target parameter index in command descriptor %s".formatted(this)));
        this.othersParameterIndex = this.findOthersParameterIndex().orElseThrow(() -> new IllegalStateException("Failed to find the others parameter index in command descriptor %s".formatted(this)));
        this.commandSourceParameterIndex = this.findCommandSourceMethodParameterSpecifierIndex().orElseThrow(() -> new IllegalStateException("Failed to find the command source parameter index in command descriptor %s".formatted(this)));
        this.fillDocument(baseCommandDescriptor.document);
    }

    public static Optional<RetargetCommandDescriptor> from(@NotNull CommandDescriptor commandDescriptor) {
        Optional<Integer> commandTargetParameterIndex = commandDescriptor.findCommandTargetMethodParameterSpecifierIndex();
        return commandTargetParameterIndex.map($commandTargetParameterIndex -> new RetargetCommandDescriptor(commandDescriptor));
    }

    private Optional<Integer> findOthersParameterIndex() {
        return this.findMethodParameterSpecifierIndex(commandArgument -> commandArgument.getArgumentName().equals(OTHERS_LITERAL) && commandArgument.isRequiredArgument());
    }

    @NotNull
    private static List<CommandArgument> makeRetargetCommandArguments(@NotNull CommandDescriptor commandDescriptor) {
        ArrayList<CommandArgument> retargetCommandArguments = new ArrayList<CommandArgument>(commandDescriptor.commandArguments);
        int commandTargetArgumentIndex = commandDescriptor.findCommandArgumentIndex(CommandArgument::isCommandTarget).orElseThrow(() -> new IllegalStateException("Failed to find the target argument index in command descriptor %s".formatted(commandDescriptor)));
        CommandArgument commandTargetArgument = (CommandArgument)retargetCommandArguments.get(commandTargetArgumentIndex);
        CommandRequirementDescriptor requirement = new CommandRequirementDescriptor(4, null);
        if (commandTargetArgument.isCommandSource()) {
            retargetCommandArguments.add(commandTargetArgumentIndex + 1, CommandArgument.ofLiteralArgument(OTHERS_LITERAL, requirement));
            retargetCommandArguments.add(commandTargetArgumentIndex + 2, CommandArgument.ofRequiredArgument(PlayerCollection.class, OTHERS_LITERAL, false, requirement));
        } else {
            retargetCommandArguments.set(commandTargetArgumentIndex, CommandArgument.ofLiteralArgument(OTHERS_LITERAL, requirement));
            retargetCommandArguments.add(commandTargetArgumentIndex + 1, CommandArgument.ofRequiredArgument(PlayerCollection.class, OTHERS_LITERAL, false, requirement));
        }
        return retargetCommandArguments;
    }

    @Override
    @NotNull
    protected Command<class_2168> makeCommandAction() {
        return this.withBaseCommandAction(commandContext -> {
            LogUtil.debug("Execute retarget command (tree): initialing command source = {}, class = {}, method = {}", ((class_2168)commandContext.getSource()).method_9214(), this.method.getDeclaringClass().getSimpleName(), this.method.getName());
            List<Object> initialingParameterValues = this.makeMethodParameterValues((CommandContext<class_2168>)commandContext);
            LogUtil.debug("Initialing parameter values: {}", initialingParameterValues);
            PlayerCollection targets = (PlayerCollection)initialingParameterValues.get(this.othersParameterIndex);
            initialingParameterValues.remove(this.othersParameterIndex);
            LogUtil.debug("Retrieved command targets: {}", ((Collection)targets.getValue()).stream().map(PlayerHelper::getPlayerName).toList());
            int treeReturnValue = 1;
            for (class_3222 target : (Collection)targets.getValue()) {
                ArrayList<Object> executingParameterValues = new ArrayList<Object>(initialingParameterValues);
                if (this.commandTargetParameterIndex == this.commandSourceParameterIndex) {
                    executingParameterValues.set(this.commandTargetParameterIndex, target);
                } else {
                    executingParameterValues.add(this.commandTargetParameterIndex, target);
                }
                LogUtil.debug("Executing parameter values: {}", executingParameterValues);
                LogUtil.debug("Execute retarget command (branch): initialing command source = {}, target = {}, class = {}, method = {}", ((class_2168)commandContext.getSource()).method_9214(), PlayerHelper.getPlayerName((class_1657)target), this.method.getDeclaringClass().getSimpleName(), this.method.getName());
                try {
                    int branchCommandReturnValue = (Integer)this.method.invoke(null, executingParameterValues.toArray());
                    LogUtil.debug("Get the command return value of retarget command (branch): target = {}, returnValue = {}", PlayerHelper.getPlayerName((class_1657)target), branchCommandReturnValue);
                    if (CommandHelper.Return.isSuccess(branchCommandReturnValue)) continue;
                    treeReturnValue = 0;
                }
                catch (Exception wrappedOrUnwrappedException) {
                    return CommandDescriptor.CommandException.handleCommandExecutionException((CommandContext<class_2168>)commandContext, this.method, wrappedOrUnwrappedException);
                }
            }
            LogUtil.debug("Get the command return value of retarget command (tree): initialing command source = {}, returnValue = {}", ((class_2168)commandContext.getSource()).method_9214(), treeReturnValue);
            return treeReturnValue;
        });
    }
}

