/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.command.executor;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class CommandExecutor {
    @NotNull
    public static List<Integer> executeBatch(@NotNull ExtendedCommandSource context, @NotNull List<String> commands) {
        return commands.stream().map(command -> CommandExecutor.executeSingle(context, command)).toList();
    }

    public static int executeSingle(@NotNull ExtendedCommandSource context, @NotNull String command) {
        return CommandExecutor.executeSingle(context, command, (TriConsumer<ExtendedCommandSource, String, Exception>)((TriConsumer)CommandExecutor::handleCommandExecutorException));
    }

    public static int executeSingle(@NotNull ExtendedCommandSource context, @NotNull String command, TriConsumer<ExtendedCommandSource, String, Exception> exceptionHandler) {
        command = context.expandCommand(command);
        LogUtil.debug("Command Executor -> Execute the command: command = `{}`, context = {}", command, context);
        try {
            return CommandHelper.getCommandDispatcher().execute(command, (Object)context.getExecutingSource());
        }
        catch (CommandSyntaxException commandSyntaxException) {
            exceptionHandler.accept((Object)context, (Object)command, (Object)commandSyntaxException);
            return 0;
        }
    }

    public static void handleCommandExecutorException(@NotNull ExtendedCommandSource context, String command, Exception exception) {
        command = TextHelper.Parsers.escapeTags(command);
        if (!context.getExecutingSource().method_43737()) {
            LogUtil.warn("Failed to execute command: command = {}, context = {}, exception = {}", command, context, exception);
        }
        TextHelper.sendTextByKey(context.getInitiatingSource(), "command.execute.echo.initiating_source", command, context.getExecutingSource().method_9214(), exception.getMessage());
        if (exception instanceof CommandSyntaxException) {
            CommandSyntaxException commandSyntaxException = (CommandSyntaxException)((Object)exception);
            TextHelper.sendMessageByText(context.getInitiatingSource(), TextHelper.TEXT_EMPTY);
            TextHelper.sendTextByKey(context.getInitiatingSource(), "command.execute.echo.execution.feedback.stream.header", new Object[0]);
            CommandExecutor.sendCommandSyntaxExceptionErrorText(context.getInitiatingSource(), command, commandSyntaxException);
            TextHelper.sendTextByKey(context.getInitiatingSource(), "command.execute.echo.execution.feedback.stream.footer", new Object[0]);
        }
        if (!context.sameSource()) {
            TextHelper.sendTextByKey(context.getExecutingSource(), "command.execute.echo.executing_source", command, exception.getMessage());
        }
    }

    private static void sendCommandSyntaxExceptionErrorText(@NotNull class_2168 serverCommandSource, @NotNull String commandString, @NotNull CommandSyntaxException commandSyntaxException) {
        serverCommandSource.method_9213(class_2564.method_10883((Message)commandSyntaxException.getRawMessage()));
        if (commandSyntaxException.getInput() != null && commandSyntaxException.getCursor() >= 0) {
            int i = Math.min(commandSyntaxException.getInput().length(), commandSyntaxException.getCursor());
            class_5250 mutableText = class_2561.method_43473().method_27692(class_124.field_1080).method_27694(style -> {
                String suggestionString = "/" + commandString;
                return style.method_10958(TextHelper.Events.ClickEvent.makeSuggestCommandAction(suggestionString));
            });
            if (i > 10) {
                mutableText.method_10852(class_5244.field_39678);
            }
            mutableText.method_27693(commandSyntaxException.getInput().substring(Math.max(0, i - 10), i));
            if (i < commandSyntaxException.getInput().length()) {
                class_5250 text = class_2561.method_43470((String)commandSyntaxException.getInput().substring(i)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1073});
                mutableText.method_10852((class_2561)text);
            }
            mutableText.method_10852((class_2561)class_2561.method_43471((String)"command.context.here").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
            serverCommandSource.method_9213((class_2561)mutableText);
        }
    }
}

