/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.command.processor;

import com.mojang.brigadier.CommandDispatcher;
import io.github.sakurawald.fuji.Fuji;
import io.github.sakurawald.fuji.core.annotation.Unused;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandArgName;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import io.github.sakurawald.fuji.core.command.argument.structure.CommandArgument;
import io.github.sakurawald.fuji.core.command.config.model.PermissionModel;
import io.github.sakurawald.fuji.core.command.descriptor.CommandDescriptor;
import io.github.sakurawald.fuji.core.command.descriptor.RetargetCommandDescriptor;
import io.github.sakurawald.fuji.core.command.structure.CommandRequirementDescriptor;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.Cite;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.server.command.CommandRegistrationEvent;
import io.github.sakurawald.fuji.core.manager.impl.module.ModuleManager;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

@Cite(value={"https://github.com/Revxrsal/Lamp", "https://github.com/henkelmax/admiral"})
@TestCase(action="List the command tree of a normal user.", targets={"The command permissions should be handled properly."})
public class CommandAnnotationProcessor {
    public static final BaseConfigurationHandler<PermissionModel> permission = ObjectConfigurationHandler.ofPath(Fuji.MOD_CONFIG_PATH.resolve("permission.json"), PermissionModel.class);
    public static final Set<CommandDescriptor> REGISTERED_COMMAND_DESCRIPTORS = ConcurrentHashMap.newKeySet();
    public static final Set<String> LOADED_COMMAND_PATHS = new HashSet<String>();
    public static final Set<String> PUBLIC_COMMAND_PATHS = new HashSet<String>();
    public static CommandDispatcher<class_2168> COMMAND_DISPATCHER;
    public static class_7157 COMMAND_REGISTRY_ACCESS;

    @EventConsumer(injectorPriority=0, consumerPriority=0)
    private static void setupCommandManagerReferences(CommandRegistrationEvent event) {
        COMMAND_DISPATCHER = event.getDispatcher();
        COMMAND_REGISTRY_ACCESS = event.getRegistryAccess();
    }

    @EventConsumer(injectorPriority=2000, consumerPriority=2000)
    private static void updateCommandTree(CommandRegistrationEvent event) {
        class_2170 commandManager = event.getCommandManager();
        CommandHelper.updateCommandTree(commandManager);
    }

    @EventConsumer
    private static void onCommandRegistrationEvent(@Unused CommandRegistrationEvent event) {
        BaseArgumentTypeAdapter.Registry.registerTypeAdapters();
        permission.readStorage();
        REGISTERED_COMMAND_DESCRIPTORS.clear();
        LOADED_COMMAND_PATHS.clear();
        PUBLIC_COMMAND_PATHS.clear();
        CommandAnnotationProcessor.processClasses();
        CommandAnnotationProcessor.removePermissionMapOfUnloadedCommandPath();
        permission.writeStorage();
    }

    private static void removePermissionMapOfUnloadedCommandPath() {
        TreeMap<String, Integer> permissionMap = permission.model().getDefaultLevelPermission().getCommands();
        permissionMap.keySet().stream().toList().forEach(key -> {
            if (!LOADED_COMMAND_PATHS.contains(key)) {
                LogUtil.warn("Removed unused permission map for command path '{}' in '{}' file.", key, permission.getFilePath());
                permissionMap.remove(key);
            }
        });
    }

    private static void processClasses() {
        ModuleManager.MODULE_INITIALIZER_BY_CLASS.values().stream().filter(Objects::nonNull).forEach(initializer -> CommandAnnotationProcessor.processClass(initializer.getClass()));
    }

    private static void processClass(@NotNull Class<?> clazz) {
        ReflectionUtil.getMethodsWithAnnotation(clazz, CommandNode.class).forEach(method -> CommandAnnotationProcessor.processMethod(clazz, method));
    }

    private static void processMethod(@NotNull Class<?> clazz, @NotNull Method method) {
        CommandAnnotationProcessor.verifyMethod(clazz, method);
        CommandDescriptor descriptor = CommandAnnotationProcessor.makeCommandDescriptor(clazz, method);
        descriptor.register();
        RetargetCommandDescriptor.from(descriptor).ifPresent(CommandDescriptor::register);
    }

    private static void verifyMethod(@NotNull Class<?> clazz, @NotNull Method method) {
        if (!method.getReturnType().equals(Integer.TYPE)) {
            throw new RuntimeException("The method `%s` in class `%s` must return the primitive int data type.".formatted(method.getName(), clazz.getName()));
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new RuntimeException("The method `%s` in class `%s` must be static.".formatted(method.getName(), clazz.getName()));
        }
    }

    @NotNull
    private static Class<?> unboxTypeClass(@NotNull Parameter parameter) {
        if (parameter.getType().equals(Optional.class)) {
            ParameterizedType parameterizedType = (ParameterizedType)parameter.getParameterizedType();
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return parameter.getType();
    }

    @NotNull
    private static CommandDescriptor makeCommandDescriptor(@NotNull Class<?> clazz, @NotNull Method method) {
        Parameter[] parameters;
        ArrayList<CommandArgument> commandArgumentList = new ArrayList<CommandArgument>();
        CommandNode classAnnotation = clazz.getAnnotation(CommandNode.class);
        CommandRequirement classRequirement = clazz.getAnnotation(CommandRequirement.class);
        if (classAnnotation != null && !classAnnotation.value().isBlank()) {
            CommandAnnotationProcessor.splitCommandNode(classAnnotation).forEach(argumentName -> commandArgumentList.add(CommandArgument.ofLiteralArgument(argumentName, CommandRequirementDescriptor.from(classRequirement))));
        }
        method.setAccessible(true);
        CommandNode methodAnnotation = method.getAnnotation(CommandNode.class);
        if (methodAnnotation.topLevel()) {
            commandArgumentList.clear();
        }
        CommandRequirement methodRequirement = null;
        for (String string : CommandAnnotationProcessor.splitCommandNode(methodAnnotation).toList()) {
            methodRequirement = method.getAnnotation(CommandRequirement.class);
            if (methodRequirement == null) {
                methodRequirement = classRequirement;
            }
            commandArgumentList.add(CommandArgument.ofLiteralArgument(string, CommandRequirementDescriptor.from(methodRequirement)));
        }
        for (Parameter parameter : parameters = method.getParameters()) {
            Class<?> typeClass = CommandAnnotationProcessor.unboxTypeClass(parameter);
            boolean isOptional = parameter.getType().equals(Optional.class);
            CommandArgument commandArgument = CommandArgument.ofRequiredArgument(typeClass, CommandAnnotationProcessor.getArgumentName(parameter), isOptional, CommandRequirementDescriptor.from(methodRequirement)).fillParameter(parameter);
            commandArgumentList.add(commandArgument);
        }
        CommandAnnotationProcessor.verifyCommandDescriptor(clazz, method, commandArgumentList);
        CommandDescriptor commandDescriptor = new CommandDescriptor(method, commandArgumentList).fillDocument(method.getAnnotation(Document.class));
        CommandDescriptor.CommandRequirement.setEffectiveDefaultCommandRequirement(commandDescriptor);
        return commandDescriptor;
    }

    private static Stream<String> splitCommandNode(@NotNull CommandNode commandNodeAnnotation) {
        String[] split = commandNodeAnnotation.value().trim().split("\\s+");
        return Arrays.stream(split).filter(argumentName -> !argumentName.trim().isBlank());
    }

    @NotNull
    private static String getArgumentName(@NotNull Parameter parameter) {
        return Optional.ofNullable(parameter.getAnnotation(CommandArgName.class)).map(CommandArgName::value).orElseGet(parameter::getName);
    }

    private static void verifyCommandDescriptor(@NotNull Class<?> clazz, @NotNull Method method, @NotNull List<CommandArgument> commandArgumentList) {
        if (commandArgumentList.isEmpty()) {
            throw new RuntimeException("The argument list of @CommandNode annotated in method `%s` in class `%s` is empty.".formatted(method.getName(), clazz.getName()));
        }
        boolean expectNonOptionalArgument = true;
        for (int i = 0; i < commandArgumentList.size(); ++i) {
            CommandArgument commandArgument = commandArgumentList.get(i);
            if (commandArgument.isGreedyArgumentType() && i != commandArgumentList.size() - 1) {
                throw new RuntimeException("The GreedyString argument type must be the last argument: class = %s, method = %s".formatted(clazz.getName(), method.getName()));
            }
            if (expectNonOptionalArgument) {
                if (!commandArgument.isOptional()) continue;
                expectNonOptionalArgument = false;
                continue;
            }
            if (commandArgument.isOptional() || commandArgument.isGreedyArgumentType()) continue;
            throw new RuntimeException("The order of argument types must be: non-optional arguments, optional arguments and greedy string argument: class = %s, method = %s".formatted(clazz.getName(), method.getName()));
        }
    }
}

