/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.handler.abst;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.sakurawald.fuji.core.auxiliary.ExceptionUtil;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.config.job.ConfigurationHandlerWriteStorageJob;
import io.github.sakurawald.fuji.core.config.mapper.GsonMapper;
import io.github.sakurawald.fuji.core.config.migrator.transformer.abst.ConfigurationTransformer;
import io.github.sakurawald.fuji.core.config.migrator.version.VersionPropertyInjector;
import io.github.sakurawald.fuji.core.document.interfaces.SourceModuleGetter;
import io.github.sakurawald.fuji.core.event.EventManager;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.consumer.BaseEventConsumer;
import io.github.sakurawald.fuji.core.event.consumer.DynamicEventConsumer;
import io.github.sakurawald.fuji.core.event.message.server.lifecycle.ServerStoppingEvent;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.core.manager.impl.module.ModulePathResolver;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDataMap;

public abstract class BaseConfigurationHandler<T>
implements SourceModuleGetter {
    public static final Set<BaseConfigurationHandler<?>> REGISTERED_CONFIGURATION_HANDLERS = new HashSet();
    public static final String CONFIG_JSON_LITERAL = "config.json";
    @NotNull
    protected final Path filePath;
    private final AtomicReference<Object> defaultModel = new AtomicReference();
    protected T model;
    private final List<Consumer<T>> preMappingModelIntoJsonObjectHooks = new ArrayList<Consumer<T>>();
    private final List<Consumer<JsonObject>> postMappingModelIntoJsonObjectHooks = new ArrayList<Consumer<JsonObject>>();
    private final List<Consumer<JsonObject>> preMappingJsonObjectIntoModelHooks = new ArrayList<Consumer<JsonObject>>();
    private final List<Consumer<T>> postMappingJsonObjectIntoModelHooks = new ArrayList<Consumer<T>>();
    private final List<ConfigurationTransformer> installedTransformers = new ArrayList<ConfigurationTransformer>();

    public BaseConfigurationHandler(@NotNull Path filePath) {
        this.filePath = filePath;
        this.addPostMappingModelIntoJsonObjectHook(VersionPropertyInjector::injectVersionProperty);
    }

    public BaseConfigurationHandler<T> addPreMappingModelIntoJsonObjectHook(@NotNull Consumer<T> hook) {
        this.preMappingModelIntoJsonObjectHooks.add(hook);
        return this;
    }

    public BaseConfigurationHandler<T> addPostMappingModelIntoJsonObjectHook(@NotNull Consumer<JsonObject> hook) {
        this.postMappingModelIntoJsonObjectHooks.add(hook);
        return this;
    }

    public BaseConfigurationHandler<T> addPreMappingJsonObjectIntoModelHook(@NotNull Consumer<JsonObject> hook) {
        this.preMappingJsonObjectIntoModelHooks.add(hook);
        return this;
    }

    public BaseConfigurationHandler<T> addPostMappingJsonObjectIntoModelHook(@NotNull Consumer<T> hook) {
        this.postMappingJsonObjectIntoModelHooks.add(hook);
        return this;
    }

    public BaseConfigurationHandler<T> installTransformer(@NotNull ConfigurationTransformer transformer) {
        this.installedTransformers.add(transformer);
        return this;
    }

    public BaseConfigurationHandler<T> installTransformer(@NotNull Supplier<ConfigurationTransformer> transformerSupplier) {
        return this.installTransformer(transformerSupplier.get());
    }

    protected abstract T makeDefaultModel();

    public final void readStorage() {
        try {
            this.installedTransformers.forEach(transformer -> transformer.tryApply(this.filePath));
            if (Files.notExists(this.filePath, new LinkOption[0])) {
                this.model = null;
                this.writeStorage();
            }
            BufferedReader jsonReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filePath.toFile()), StandardCharsets.UTF_8));
            try {
                JsonObject jsonObject = GsonMapper.fromJson(jsonReader, JsonObject.class);
                this.validateModel(jsonObject, this.getDefaultModelAsJsonTree());
                this.preMappingJsonObjectIntoModelHooks.forEach(hook -> hook.accept(jsonObject));
                this.model = GsonMapper.fromJson((JsonElement)jsonObject, this.getDefaultModel().getClass());
                this.postMappingJsonObjectIntoModelHooks.forEach(hook -> hook.accept(this.model));
                this.writeStorage();
                REGISTERED_CONFIGURATION_HANDLERS.add(this);
            }
            finally {
                if (Collections.singletonList(jsonReader).get(0) != null) {
                    ((Reader)jsonReader).close();
                }
            }
        }
        catch (Exception e) {
            this.handleConfigurationHandlerException("Failed to read a file", e);
        }
    }

    private void handleConfigurationHandlerException(@NotNull String title, @NotNull Exception e) {
        String modulePath = ModulePathResolver.computeModulePathString(this.makeDefaultModel().getClass().getName());
        LogUtil.error("\n\n[{}]\nFailed to read configuration file '{}' from storage.\n\n\u25c9 Module: {}\n\u25c9 File Path: {}\n\u25c9 Message: {}\n", title, this.filePath, modulePath, this.filePath, e.getMessage());
        throw ExceptionUtil.makeReThrownException(e);
    }

    public final void writeStorage() {
        try {
            if (this.model == null) {
                this.model = this.getDefaultModel();
                LogUtil.debug("Write default configuration: {}", this.filePath.toFile().getAbsolutePath());
            }
            this.preMappingModelIntoJsonObjectHooks.forEach(hook -> hook.accept(this.model()));
            JsonObject jsonObject = this.getModelAsJsonTree();
            this.postMappingModelIntoJsonObjectHooks.forEach(hook -> hook.accept(jsonObject));
            Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
            Files.writeString(this.filePath, (CharSequence)GsonMapper.toJsonString((JsonElement)jsonObject), new OpenOption[0]);
        }
        catch (Exception e) {
            this.handleConfigurationHandlerException("Failed to write a file", e);
        }
    }

    protected void validateModel(@NotNull JsonObject dataTree, @NotNull JsonObject schemaTree) {
    }

    @NotNull
    public JsonObject getModelAsJsonTree() {
        return GsonMapper.toJsonTree(this.model()).getAsJsonObject();
    }

    @NotNull
    public JsonObject getDefaultModelAsJsonTree() {
        return GsonMapper.toJsonTree(this.getDefaultModel()).getAsJsonObject();
    }

    @NotNull
    public T model() {
        if (this.model == null) {
            this.readStorage();
        }
        if (this.model == null) {
            throw new IllegalStateException("The model of configuration file %s is null".formatted(this.filePath));
        }
        return this.model;
    }

    @Override
    public String getSourceModule() {
        return ModulePathResolver.computeModulePathString(this.model().getClass().getName());
    }

    public BaseConfigurationHandler<T> enableAutoSaveFeature() {
        return this.enableAutoSaveFeature("0/10 * * ? * * *");
    }

    @EventConsumer(eventType=ServerStoppingEvent.class, isDynamic=true)
    public BaseConfigurationHandler<T> enableAutoSaveFeature(@NotNull String cron) {
        String jobName = this.filePath.toFile().getCanonicalPath();
        ConfigurationHandlerWriteStorageJob writeStorageJob = new ConfigurationHandlerWriteStorageJob(jobName, new JobDataMap(){
            {
                this.put(BaseConfigurationHandler.class.getName(), BaseConfigurationHandler.this);
                String sourceModuleInCurrentStackTrace = ReflectionUtil.Stacktrace.findSourceModuleInCurrentStackTrace();
                this.put("source-module", sourceModuleInCurrentStackTrace);
            }
        }, () -> cron);
        Managers.getScheduleManager().scheduleJob(writeStorageJob);
        BaseEventConsumer<ServerStoppingEvent> dynamicEventConsumer = DynamicEventConsumer.makeDynamic(ServerStoppingEvent.class, 1000, 1000, server -> {
            LogUtil.debug("Write storage on server stopping: {}", this.filePath);
            this.writeStorage();
        });
        EventManager.registerEventConsumer(ServerStoppingEvent.class, dynamicEventConsumer);
        return this;
    }

    @NotNull
    @Generated
    public Path getFilePath() {
        return this.filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public T getDefaultModel() {
        Object $value = this.defaultModel.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.defaultModel;
            synchronized (atomicReference) {
                $value = this.defaultModel.get();
                if ($value == null) {
                    T actualValue = this.makeDefaultModel();
                    $value = actualValue == null ? this.defaultModel : actualValue;
                    this.defaultModel.set($value);
                }
            }
        }
        return (T)($value == this.defaultModel ? null : $value);
    }

    @Generated
    protected BaseConfigurationHandler<T> setModel(T model) {
        this.model = model;
        return this;
    }
}

