/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.handler.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.sakurawald.fuji.Fuji;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.config.exception.FailedToLoadResourceException;
import io.github.sakurawald.fuji.core.config.handler.impl.ResourceConfigurationHandler;
import io.github.sakurawald.fuji.core.config.migrator.transformer.impl.MoveFileTransformer;
import io.github.sakurawald.fuji.core.config.validator.ArgumentsValidator;
import io.github.sakurawald.fuji.core.document.structure.DocString;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class LanguageConfigurationHandler
extends ResourceConfigurationHandler {
    private static final String LANGUAGE_DIRECTORY_NAME = "languages";
    private static final String LANGUAGE_FILE_CLASS_PATH_PREFIX = "/languages/";
    private static final String FALLBACK_LANGUAGE_FILE_CLASS_PATH = "/languages/" + LanguageConfigurationHandler.toLanguageFileName("en_US");
    public static final String JSON_FILE_EXTENSION_LITERAL = ".json";

    public LanguageConfigurationHandler(@NotNull String languageCode) {
        super(LanguageConfigurationHandler.getLanguageFilePath(languageCode), LanguageConfigurationHandler.getLanguageFileClassPath(languageCode));
        this.installTransformer(new MoveFileTransformer(Fuji.MOD_CONFIG_PATH.resolve("lang"), Fuji.MOD_CONFIG_PATH.resolve(LANGUAGE_DIRECTORY_NAME)));
        this.addPreMappingModelIntoJsonObjectHook(model -> this.setModel(LanguageConfigurationHandler.makeSortedLanguageJsonObject(model)));
    }

    @NotNull
    private static Path getLanguageFilePath(@NotNull String languageCode) {
        String languageFileName = LanguageConfigurationHandler.toLanguageFileName(languageCode);
        return Fuji.MOD_CONFIG_PATH.resolve(LANGUAGE_DIRECTORY_NAME).resolve(languageFileName);
    }

    @NotNull
    private static String getLanguageFileClassPath(@NotNull String languageCode) {
        return LANGUAGE_FILE_CLASS_PATH_PREFIX + LanguageConfigurationHandler.toLanguageFileName(languageCode);
    }

    @NotNull
    private static String toLanguageFileName(@NotNull String languageCode) {
        return languageCode + JSON_FILE_EXTENSION_LITERAL;
    }

    @NotNull
    public static String toLanguageCode(@NotNull String languageFileName) {
        return languageFileName.replace(JSON_FILE_EXTENSION_LITERAL, "");
    }

    @NotNull
    public static JsonObject makeSortedLanguageJsonObject(@NotNull JsonObject original) {
        TreeMap<String, JsonElement> sortedMap = new TreeMap<String, JsonElement>((a, b) -> {
            boolean aIsDocString = a.startsWith("docstring.");
            boolean bIsDocString = b.startsWith("docstring.");
            if (aIsDocString && !bIsDocString) {
                return 1;
            }
            if (!aIsDocString && bIsDocString) {
                return -1;
            }
            if (aIsDocString && bIsDocString) {
                long aId = DocString.parseDocStringId(a);
                long bId = DocString.parseDocStringId(b);
                return Long.compare(aId, bId);
            }
            return a.compareTo((String)b);
        });
        for (Map.Entry entry : original.entrySet()) {
            sortedMap.put((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        JsonObject sortedJson = new JsonObject();
        for (Map.Entry entry : sortedMap.entrySet()) {
            sortedJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return sortedJson;
    }

    @Override
    protected JsonObject makeDefaultModel() {
        try {
            return LanguageConfigurationHandler.loadJsonFileFromResourceClassPath(this.resourceClassPath);
        }
        catch (FailedToLoadResourceException e) {
            LogUtil.debug("Failed to make the default configuration model from `{}` resource path. (Fallback to the `{}`)", this.resourceClassPath, FALLBACK_LANGUAGE_FILE_CLASS_PATH);
            return LanguageConfigurationHandler.loadJsonFileFromResourceClassPath(FALLBACK_LANGUAGE_FILE_CLASS_PATH);
        }
    }

    @Override
    protected void validateModel(@NotNull JsonObject dataTree, @NotNull JsonObject schemaTree) {
        super.validateModel(dataTree, schemaTree);
        ArgumentsValidator.validateArguments(this, dataTree, schemaTree);
    }
}

