/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.mapper;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.properties.PropertyMap;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.StringUtil;
import io.github.sakurawald.fuji.core.config.annotation.NotNullEnumType;
import io.github.sakurawald.fuji.core.config.mapper.adapter.BiMapTypeAdapterFactory;
import io.github.sakurawald.fuji.core.config.mapper.adapter.CheckedEnumTypeValueAdapterFactory;
import io.github.sakurawald.fuji.core.config.migrator.version.IgnoreModVersionFieldStrategy;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class GsonMapper {
    private static Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().disableHtmlEscaping().serializeNulls().setExclusionStrategies(new ExclusionStrategy[]{new IgnoreModVersionFieldStrategy()}).disableJdkUnsafe().disableInnerClassSerialization().registerTypeAdapterFactory((TypeAdapterFactory)new BiMapTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new CheckedEnumTypeValueAdapterFactory()).registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).create();
    private static final Map<Class<?>, Boolean> TYPE_NULLABILITY_MAP = new ConcurrentHashMap();

    @NotNull
    private static Gson getFallbackGson() {
        GsonBuilder fallbackGsonBuilder = gson.newBuilder();
        GsonMapper.enableJdkUnsafeFeature(fallbackGsonBuilder);
        return fallbackGsonBuilder.create();
    }

    private static void enableJdkUnsafeFeature(@NotNull GsonBuilder builder) {
        try {
            Field field = GsonBuilder.class.getDeclaredField("useJdkUnsafe");
            field.setAccessible(true);
            field.setBoolean(builder, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to enable JDK Unsafe Feature in GsonBuilder.", e);
        }
    }

    @NotNull
    public static Gson __GetInternalGsonReferenceWithoutTheUseOfWrappedFunctions() {
        return gson;
    }

    public static <T> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory skipPast, TypeToken<T> type) {
        return gson.getDelegateAdapter(skipPast, type);
    }

    public static void registerGsonTypeAdapter(@NotNull Type type, @NotNull Object typeAdapter) {
        gson = gson.newBuilder().registerTypeAdapter(type, typeAdapter).create();
    }

    public static void setTypeNullability(@NotNull Class<?> typeClass, boolean nullable) {
        TYPE_NULLABILITY_MAP.put(typeClass, nullable);
    }

    public static boolean isNullableType(@NotNull Class<?> typeClass) {
        return TYPE_NULLABILITY_MAP.computeIfAbsent(typeClass, k -> {
            boolean nullable = Optional.ofNullable(typeClass.getAnnotation(NotNullEnumType.class)).isEmpty();
            return nullable;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static <T> T fromJson(@NotNull Path filePath, @NotNull TypeToken<T> runtimeType) {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath.toFile()), StandardCharsets.UTF_8));
        try {
            Object object = gson.fromJson((Reader)reader, runtimeType);
            return (T)object;
        }
        catch (JsonIOException e) {
            GsonMapper.handleGsonJdkUnsafeDisabledException(runtimeType.getType(), e);
            Object object2 = GsonMapper.getFallbackGson().fromJson((Reader)reader, runtimeType);
            return (T)object2;
        }
        finally {
            if (Collections.singletonList(reader).get(0) != null) {
                ((Reader)reader).close();
            }
        }
    }

    @NotNull
    public static <T> T fromJson(@NotNull Reader jsonReader, @NotNull Class<T> rawType) {
        try {
            return (T)gson.fromJson(jsonReader, rawType);
        }
        catch (JsonIOException e) {
            GsonMapper.handleGsonJdkUnsafeDisabledException(rawType, e);
            return (T)GsonMapper.getFallbackGson().fromJson(jsonReader, rawType);
        }
    }

    @NotNull
    public static <T> T fromJson(@NotNull String json, @NotNull Class<T> rawType) throws JsonSyntaxException {
        try {
            return (T)gson.fromJson(json, rawType);
        }
        catch (JsonIOException e) {
            GsonMapper.handleGsonJdkUnsafeDisabledException(rawType, e);
            return (T)GsonMapper.getFallbackGson().fromJson(json, rawType);
        }
    }

    @NotNull
    public static <T> T fromJson(@NotNull JsonElement jsonElement, @NotNull Class<T> rawType) throws JsonSyntaxException {
        try {
            return (T)gson.fromJson(jsonElement, rawType);
        }
        catch (JsonIOException e) {
            GsonMapper.handleGsonJdkUnsafeDisabledException(rawType, e);
            return (T)GsonMapper.getFallbackGson().fromJson(jsonElement, rawType);
        }
    }

    private static void handleGsonJdkUnsafeDisabledException(@NotNull Type type, JsonIOException e) {
        if (!StringUtil.toLowerCase(e.getMessage()).contains("jdk unsafe")) {
            throw e;
        }
        LogUtil.warn("\n[JDK Unsafe feature is used to create a Java Object instance]\n\u25c9 Problem: Failed to create instance of {} using vanilla Java NoArgsConstructor, now falling back to use JDK Unsafe to create the instance.\n\u25c9 Solution: If you see this, you should create an issue in https://github.com/sakurawald/fuji/issues\n", type);
    }

    @NotNull
    public static JsonElement toJsonTree(@NotNull Object src) {
        return gson.toJsonTree(src);
    }

    @NotNull
    public static String toJsonString(@NotNull Object src) {
        return gson.toJson(src);
    }

    @NotNull
    public static String toJsonString(@NotNull JsonElement jsonElement) {
        return gson.toJson(jsonElement);
    }
}

