/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.migrator.transformer.abst;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.config.migrator.exception.AbortConfigurationMigrationException;
import java.nio.file.Path;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurationTransformer {
    protected Path targetFilePath;

    private void configure(@NotNull Path targetFilePath) {
        this.targetFilePath = targetFilePath;
    }

    public final void tryApply(@NotNull Path targetFilePath) {
        try {
            this.configure(targetFilePath);
            boolean canApply = this.canApply();
            LogUtil.debug("tryApply(): filePath = {}, transformer = {}, canApply = {}", this.targetFilePath, this.getClass().getName(), canApply);
            if (canApply) {
                this.apply();
            }
        }
        catch (AbortConfigurationMigrationException abortConfigurationMigrationException) {
            // empty catch block
        }
    }

    protected abstract boolean canApply();

    protected abstract void apply();

    protected void logOperation(@NotNull String message, Object ... args) {
        Object[] finalArgs = new Object[args.length + 1];
        finalArgs[0] = this.targetFilePath;
        System.arraycopy(args, 0, finalArgs, 1, args.length);
        LogUtil.warn("Apply the transformer installed on the file `{}`\n => " + message, finalArgs);
    }

    @Generated
    public Path getTargetFilePath() {
        return this.targetFilePath;
    }
}

