/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.migrator.transformer.abst;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.sakurawald.fuji.core.auxiliary.JsonUtil;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.config.migrator.transformer.abst.ConfigurationTransformer;
import io.github.sakurawald.fuji.core.config.migrator.version.SemVerComparator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public abstract class JsonConfigurationTransformer
extends ConfigurationTransformer {
    public abstract String sinceVersion();

    @Override
    protected boolean canApply() {
        String sinceVersionString;
        String jsonVersionString = this.getJsonVersion();
        return SemVerComparator.compareSemVer(jsonVersionString, sinceVersionString = this.sinceVersion()) < 0;
    }

    @NotNull
    private String getJsonVersion() {
        try {
            if (Files.notExists(this.getTargetFilePath(), new LinkOption[0])) {
                return "1.0.0";
            }
            return this.readTargetJsonFile().map(jsonObject -> jsonObject.get("MOD_VERSION")).map(JsonElement::getAsString).orElseGet(() -> {
                String fallbackModVersion = "1.0.0";
                LogUtil.warn("There is no mod version string in file {}, treating it as {}", this.targetFilePath, fallbackModVersion);
                return fallbackModVersion;
            });
        }
        catch (Exception e) {
            String fallbackModVersion = "1.0.0";
            LogUtil.warn("Failed to read the file to get the mod version string, treating it as {}", this.targetFilePath, fallbackModVersion);
            return fallbackModVersion;
        }
    }

    @NotNull
    protected Optional<JsonObject> readTargetJsonFile() {
        try {
            return Optional.of(JsonUtil.readJsonFile(this.getTargetFilePath()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    protected void writeTargetJsonFile(@NotNull JsonObject rootJsonObject) {
        this.logOperation("Transformer {} applied, now override the original file.", this.getClass().getName());
        JsonUtil.writeJsonObject(rootJsonObject, this.targetFilePath);
    }

    protected void withTargetJsonFile(BiConsumer<JsonObject, AtomicBoolean> consumer) {
        this.readTargetJsonFile().ifPresent(jsonObject -> {
            AtomicBoolean overrideTargetFile = new AtomicBoolean(false);
            consumer.accept((JsonObject)jsonObject, overrideTargetFile);
            if (overrideTargetFile.get()) {
                this.writeTargetJsonFile((JsonObject)jsonObject);
            }
        });
    }
}

