/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.migrator.transformer.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.sakurawald.fuji.core.config.migrator.transformer.abst.ConfigurationTransformer;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class InflateJsonPrimitivesIntoJsonObjectTransformer
extends ConfigurationTransformer {
    @NotNull
    private final JsonObject sourceJsonObject;
    @NotNull
    private final List<String> jsonKeys;
    @NotNull
    private final Function<JsonObject, JsonObject> destinationJsonObjectMaker;

    @Override
    protected boolean canApply() {
        return this.jsonKeys.stream().allMatch(arg_0 -> ((JsonObject)this.sourceJsonObject).has(arg_0));
    }

    @Override
    protected void apply() {
        @NotNull JsonObject sourceJsonObject = this.sourceJsonObject;
        @NotNull List<String> jsonKeys = this.jsonKeys;
        @NotNull JsonObject destinationJsonObject = this.destinationJsonObjectMaker.apply(sourceJsonObject);
        jsonKeys.forEach(jsonKey -> {
            if (!destinationJsonObject.has(jsonKey)) {
                JsonElement jsonValue = this.sourceJsonObject.get(jsonKey);
                destinationJsonObject.add(jsonKey, jsonValue);
            }
        });
        jsonKeys.forEach(arg_0 -> ((JsonObject)sourceJsonObject).remove(arg_0));
    }

    @Generated
    public InflateJsonPrimitivesIntoJsonObjectTransformer(@NotNull JsonObject sourceJsonObject, @NotNull List<String> jsonKeys, @NotNull Function<JsonObject, JsonObject> destinationJsonObjectMaker) {
        if (sourceJsonObject == null) {
            throw new NullPointerException("sourceJsonObject is marked non-null but is null");
        }
        if (jsonKeys == null) {
            throw new NullPointerException("jsonKeys is marked non-null but is null");
        }
        if (destinationJsonObjectMaker == null) {
            throw new NullPointerException("destinationJsonObjectMaker is marked non-null but is null");
        }
        this.sourceJsonObject = sourceJsonObject;
        this.jsonKeys = jsonKeys;
        this.destinationJsonObjectMaker = destinationJsonObjectMaker;
    }

    @NotNull
    @Generated
    public JsonObject getSourceJsonObject() {
        return this.sourceJsonObject;
    }

    @NotNull
    @Generated
    public List<String> getJsonKeys() {
        return this.jsonKeys;
    }

    @NotNull
    @Generated
    public Function<JsonObject, JsonObject> getDestinationJsonObjectMaker() {
        return this.destinationJsonObjectMaker;
    }

    @Generated
    public String toString() {
        return "InflateJsonPrimitivesIntoJsonObjectTransformer(sourceJsonObject=" + String.valueOf(this.getSourceJsonObject()) + ", jsonKeys=" + String.valueOf(this.getJsonKeys()) + ", destinationJsonObjectMaker=" + String.valueOf(this.getDestinationJsonObjectMaker()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InflateJsonPrimitivesIntoJsonObjectTransformer)) {
            return false;
        }
        InflateJsonPrimitivesIntoJsonObjectTransformer other = (InflateJsonPrimitivesIntoJsonObjectTransformer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonObject this$sourceJsonObject = this.getSourceJsonObject();
        JsonObject other$sourceJsonObject = other.getSourceJsonObject();
        if (this$sourceJsonObject == null ? other$sourceJsonObject != null : !this$sourceJsonObject.equals(other$sourceJsonObject)) {
            return false;
        }
        List<String> this$jsonKeys = this.getJsonKeys();
        List<String> other$jsonKeys = other.getJsonKeys();
        if (this$jsonKeys == null ? other$jsonKeys != null : !((Object)this$jsonKeys).equals(other$jsonKeys)) {
            return false;
        }
        Function<JsonObject, JsonObject> this$destinationJsonObjectMaker = this.getDestinationJsonObjectMaker();
        Function<JsonObject, JsonObject> other$destinationJsonObjectMaker = other.getDestinationJsonObjectMaker();
        return !(this$destinationJsonObjectMaker == null ? other$destinationJsonObjectMaker != null : !this$destinationJsonObjectMaker.equals(other$destinationJsonObjectMaker));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InflateJsonPrimitivesIntoJsonObjectTransformer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JsonObject $sourceJsonObject = this.getSourceJsonObject();
        result = result * 59 + ($sourceJsonObject == null ? 43 : $sourceJsonObject.hashCode());
        List<String> $jsonKeys = this.getJsonKeys();
        result = result * 59 + ($jsonKeys == null ? 43 : ((Object)$jsonKeys).hashCode());
        Function<JsonObject, JsonObject> $destinationJsonObjectMaker = this.getDestinationJsonObjectMaker();
        result = result * 59 + ($destinationJsonObjectMaker == null ? 43 : $destinationJsonObjectMaker.hashCode());
        return result;
    }
}

