/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.migrator.transformer.impl;

import io.github.sakurawald.fuji.core.config.migrator.transformer.abst.ConfigurationTransformer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class MoveFileTransformer
extends ConfigurationTransformer {
    @NotNull
    private Path sourceFile;
    @NotNull
    private Path destinationFile;

    @Override
    protected boolean canApply() {
        if (Files.notExists(this.sourceFile, new LinkOption[0])) {
            return false;
        }
        return !Files.exists(this.destinationFile, new LinkOption[0]);
    }

    @Override
    protected void apply() {
        this.logOperation("Move file: sourceFile = {}, destinationFile = {}", this.sourceFile, this.destinationFile);
        Files.createDirectories(this.destinationFile.getParent(), new FileAttribute[0]);
        Files.move(this.sourceFile, this.destinationFile, new CopyOption[0]);
    }

    @Generated
    public MoveFileTransformer(@NotNull Path sourceFile, @NotNull Path destinationFile) {
        if (sourceFile == null) {
            throw new NullPointerException("sourceFile is marked non-null but is null");
        }
        if (destinationFile == null) {
            throw new NullPointerException("destinationFile is marked non-null but is null");
        }
        this.sourceFile = sourceFile;
        this.destinationFile = destinationFile;
    }
}

