/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.migrator.transformer.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.sakurawald.fuji.core.config.migrator.transformer.abst.ConfigurationTransformer;
import io.github.sakurawald.fuji.core.structure.Pair;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class RenameJsonKeysTransformer
extends ConfigurationTransformer {
    @NotNull
    private final JsonObject jsonObject;
    @NotNull
    private final List<Pair<String, String>> renameRules;

    @Override
    protected boolean canApply() {
        return this.renameRules.stream().anyMatch(rule -> {
            String oldJsonKey = (String)rule.getKey();
            return this.jsonObject.has(oldJsonKey);
        });
    }

    @Override
    protected void apply() {
        this.renameRules.forEach(rule -> {
            String oldJsonKey = (String)rule.getKey();
            String newJsonKey = (String)rule.getValue();
            if (this.jsonObject.has(oldJsonKey) && !this.jsonObject.has(newJsonKey)) {
                JsonElement value = this.jsonObject.get(oldJsonKey);
                this.jsonObject.add(newJsonKey, value);
                this.jsonObject.remove(oldJsonKey);
            }
        });
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenameJsonKeysTransformer)) {
            return false;
        }
        RenameJsonKeysTransformer other = (RenameJsonKeysTransformer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonObject this$jsonObject = this.getJsonObject();
        JsonObject other$jsonObject = other.getJsonObject();
        if (this$jsonObject == null ? other$jsonObject != null : !this$jsonObject.equals(other$jsonObject)) {
            return false;
        }
        List<Pair<String, String>> this$renameRules = this.getRenameRules();
        List<Pair<String, String>> other$renameRules = other.getRenameRules();
        return !(this$renameRules == null ? other$renameRules != null : !((Object)this$renameRules).equals(other$renameRules));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RenameJsonKeysTransformer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JsonObject $jsonObject = this.getJsonObject();
        result = result * 59 + ($jsonObject == null ? 43 : $jsonObject.hashCode());
        List<Pair<String, String>> $renameRules = this.getRenameRules();
        result = result * 59 + ($renameRules == null ? 43 : ((Object)$renameRules).hashCode());
        return result;
    }

    @Generated
    public RenameJsonKeysTransformer(@NotNull JsonObject jsonObject, @NotNull List<Pair<String, String>> renameRules) {
        if (jsonObject == null) {
            throw new NullPointerException("jsonObject is marked non-null but is null");
        }
        if (renameRules == null) {
            throw new NullPointerException("renameRules is marked non-null but is null");
        }
        this.jsonObject = jsonObject;
        this.renameRules = renameRules;
    }

    @NotNull
    @Generated
    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    @NotNull
    @Generated
    public List<Pair<String, String>> getRenameRules() {
        return this.renameRules;
    }

    @Generated
    public String toString() {
        return "RenameJsonKeysTransformer(jsonObject=" + String.valueOf(this.getJsonObject()) + ", renameRules=" + String.valueOf(this.getRenameRules()) + ")";
    }
}

