/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.validator;

import com.google.gson.JsonObject;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.config.Configs;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.validator.structure.StringOccurenceMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ArgumentsValidator {
    public static void validateArguments(@NotNull BaseConfigurationHandler<?> handler, @NotNull JsonObject dataTree, @NotNull JsonObject schemaTree) {
        if (!Configs.MAIN_CONTROL_CONFIG.model().core.language.validator.validate_arguments) {
            return;
        }
        schemaTree.keySet().forEach(key -> {
            ArgumentsValidator.validateArgumentCount("Java String Formatter", handler, StringOccurenceMap.JavaFormatterLanguage::makeOccurenceMap, key, dataTree, schemaTree);
            ArgumentsValidator.validateArgumentCount("Named Arguments", handler, StringOccurenceMap.NamedArgumentsLanguage::makeOccurenceMap, key, dataTree, schemaTree);
        });
    }

    private static void validateArgumentCount(@NotNull String checkName, @NotNull BaseConfigurationHandler<?> baseConfigurationHandler, @NotNull Function<String, StringOccurenceMap> mapper, @NotNull String languageKey, @NotNull JsonObject dataTree, @NotNull JsonObject schemaTree) {
        StringOccurenceMap dataMap;
        String schemaValue = schemaTree.get(languageKey).getAsString();
        String dataValue = dataTree.get(languageKey).getAsString();
        StringOccurenceMap schemaMap = mapper.apply(schemaValue);
        if (!schemaMap.equals(dataMap = mapper.apply(dataValue))) {
            LogUtil.warn("\n[Arguments Validation Failed]\nThe number of arguments for [{}] does not match between [actual language value] and [expected language value].\nOverride the [actual language value] to match it now.\n\n\u25c9 Language File: {}\n\u25c9 Language Key: {}\n\u25c9 Actual Language Value: {}\n\u25c9 Expected Language Value: {}\n", checkName, baseConfigurationHandler.getFilePath(), languageKey, dataValue, schemaValue);
            dataTree.addProperty(languageKey, schemaValue);
        }
    }
}

