/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.validator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class RemoveNullElementsInJsonArrayValidator {
    public static void validate(@NotNull JsonObject dataTree) {
        dataTree.keySet().forEach(key -> {
            JsonElement jsonElement = dataTree.get(key);
            if (jsonElement.isJsonObject()) {
                RemoveNullElementsInJsonArrayValidator.validate(jsonElement.getAsJsonObject());
                return;
            }
            if (!jsonElement.isJsonArray()) {
                return;
            }
            JsonArray jsonArray = dataTree.get(key).getAsJsonArray();
            ArrayList arrayElementsToRemove = new ArrayList();
            jsonArray.forEach(arrayElement -> {
                if (arrayElement.isJsonObject()) {
                    RemoveNullElementsInJsonArrayValidator.validate(arrayElement.getAsJsonObject());
                }
                if (arrayElement.isJsonNull()) {
                    arrayElementsToRemove.add(arrayElement);
                }
            });
            if (!arrayElementsToRemove.isEmpty()) {
                LogUtil.warn("Remove JsonNull elements {} in JsonArray {}", arrayElementsToRemove, jsonArray);
                arrayElementsToRemove.forEach(arg_0 -> ((JsonArray)jsonArray).remove(arg_0));
            }
        });
    }
}

