/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.validator.structure;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class StringOccurenceMap {
    private final Map<String, Integer> map = new HashMap<String, Integer>();

    public void countOnce(@NotNull String string) {
        this.map.compute(string, (k, v) -> v == null ? 1 : v + 1);
    }

    @NotNull
    private static StringOccurenceMap makeStringOccurenceMap(@NotNull Pattern pattern, @NotNull String inputString) {
        StringOccurenceMap result = new StringOccurenceMap();
        Matcher matcher = pattern.matcher(inputString);
        while (matcher.find()) {
            String captureConversion = matcher.group(0);
            result.countOnce(captureConversion);
        }
        return result;
    }

    @Generated
    public String toString() {
        return "StringOccurenceMap(map=" + String.valueOf(this.map) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringOccurenceMap)) {
            return false;
        }
        StringOccurenceMap other = (StringOccurenceMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Integer> this$map = this.map;
        Map<String, Integer> other$map = other.map;
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StringOccurenceMap;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Integer> $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    public static class NamedArgumentsLanguage {
        private static final Pattern textArgumentPlaceholderLanguage = Pattern.compile("(\\$\\{.+?})");

        @NotNull
        public static StringOccurenceMap makeOccurenceMap(@NotNull String inputString) {
            return StringOccurenceMap.makeStringOccurenceMap(textArgumentPlaceholderLanguage, inputString);
        }
    }

    public static class JavaFormatterLanguage {
        private static final Pattern javaFormatterLanguage = Pattern.compile("(%[%bcdfsn])");

        @NotNull
        public static StringOccurenceMap makeOccurenceMap(@NotNull String inputString) {
            return StringOccurenceMap.makeStringOccurenceMap(javaFormatterLanguage, inputString);
        }
    }
}

