/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.document.auxiliary;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.service.url_highlighter.UrlHighlighter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentUtil {
    @NotNull
    public static String getDocString(@Nullable Object audience, long id) {
        if (id == 0L) {
            return "DUMMY-DOC-STRING";
        }
        String languageKey = "docstring." + id;
        String languageValue = TextHelper.Translator.getLanguageValueByKey(audience, languageKey);
        return languageValue;
    }

    @Nullable
    private static String getDocumentString(@Nullable Object audience, @Nullable Document annotation) {
        if (annotation == null) {
            return null;
        }
        if (TextHelper.Loader.shouldUseBuiltInDocStrings()) {
            return annotation.value();
        }
        return DocumentUtil.getDocString(audience, annotation.id());
    }

    @Nullable
    public static String getColorBoxString(@Nullable Object audience, @Nullable ColorBox annotation) {
        if (annotation == null) {
            return null;
        }
        if (TextHelper.Loader.shouldUseBuiltInDocStrings()) {
            return annotation.value();
        }
        return DocumentUtil.getDocString(audience, annotation.id());
    }

    @Nullable
    public static String getClassDocumentString(@Nullable Object audience, @NotNull Class<?> clazz) {
        Document annotation = clazz.getAnnotation(Document.class);
        return DocumentUtil.getDocumentString(audience, annotation);
    }

    @Nullable
    public static String getFieldDocumentString(@Nullable Object audience, @NotNull Field field) {
        Document annotation = field.getAnnotation(Document.class);
        return DocumentUtil.getDocumentString(audience, annotation);
    }

    @NotNull
    public static String compileDocumentString(@NotNull String documentString) {
        return Arrays.stream(documentString.split("\n")).map(DocumentUtil::compileDocumentStringLine).collect(Collectors.joining("\n"));
    }

    @NotNull
    private static String compileDocumentStringLine(@NotNull String line) {
        if (((String)line).startsWith("\u25c9")) {
            line = "<bold>" + (String)line;
        }
        line = ((String)line).replaceAll("\\*\\*(.+?)\\*\\*", "<bold>$1</bold>");
        line = ((String)line).replace("*", "\\*");
        line = UrlHighlighter.highlight((String)line);
        line = ((String)line).replaceAll("`/(.+?)`", "<gold>/$1</gold>");
        line = ((String)line).replaceAll("`(.+?)`", "<grey>$1</grey>");
        line = ((String)line).replaceAll("%(.+?:.+?)%", "<aqua>%$1%</aqua>");
        line = ((String)line).replaceAll("Alex", "<dark_green>Alex</dark_green>");
        line = ((String)line).replaceAll("Steve", "<dark_green>Steve</dark_green>");
        line = ((String)line).replaceAll("Alice", "<dark_green>Alice</dark_green>");
        line = ((String)line).replaceAll("Bob", "<dark_green>Bob</dark_green>");
        line = ((String)line).replaceAll("Carol", "<dark_green>Carol</dark_green>");
        line = ((String)line).replaceAll("Dave", "<dark_green>Dave</dark_green>");
        line = ((String)line).replaceAll("@a", "<#FF0000>@a</#FF0000>");
        line = ((String)line).replaceAll("@e", "<#FF0000>@e</#FF0000>");
        line = ((String)line).replaceAll("@n", "<#FF0000>@n</#FF0000>");
        line = ((String)line).replaceAll("@p", "<#FF0000>@p</#FF0000>");
        line = ((String)line).replaceAll("@r", "<#FF0000>@r</#FF0000>");
        line = ((String)line).replaceAll("@s", "<#FF0000>@s</#FF0000>");
        line = ((String)line).replaceAll("If ", "<#B13BFF>If </#B13BFF>");
        line = ((String)line).replaceAll("if ", "<#B13BFF>if </#B13BFF>");
        line = ((String)line).replaceAll("then ", "<#B13BFF>then </#B13BFF>");
        line = ((String)line).replaceAll("else ", "<#B13BFF>else </#B13BFF>");
        line = ((String)line).replaceAll("\\bIF\\b", "<blue>IF</blue>");
        line = ((String)line).replaceAll("\\bTHEN\\b", "<blue>THEN</blue>");
        line = ((String)line).replaceAll("\\bELSE\\b", "<blue>ELSE</blue>");
        line = ((String)line).replaceAll("^(\\d\\. )", "<#87CEEB>$1</#87CEEB>");
        line = ((String)line).replaceAll("^(\\d\\.[a-z]\\. )", "<#87CEEB>$1</#87CEEB>");
        line = ((String)line).replaceAll("^(\\d\\.[a-z]\\.\\w+?\\. )", "<#87CEEB>$1</#87CEEB>");
        line = ((String)line).replaceAll("\\\\<(.+?)\\\\>", "<yellow>\\\\<$1\\\\></yellow>");
        line = TextHelper.Fixer.fixParserInput((String)line);
        return "<#FFA1F5>" + (String)line;
    }
}

