/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.event.injector;

import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.event.EventManager;
import io.github.sakurawald.fuji.core.event.consumer.BaseEventConsumer;
import io.github.sakurawald.fuji.core.event.consumer.StaticEventConsumer;
import io.github.sakurawald.fuji.core.event.injector.structure.EventConsumerInfo;
import io.github.sakurawald.fuji.core.event.injector.structure.EventGraph;
import io.github.sakurawald.fuji.core.event.injector.structure.EventProducerInfo;
import io.github.sakurawald.fuji.core.event.message.BaseEvent;
import io.github.sakurawald.fuji.core.manager.impl.module.ModuleLoadDeterminer;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class StaticEventConsumerInjector {
    private static final AtomicReference<Object> eventProducerMixinClassNames = new AtomicReference();

    public static void injectAll() {
        EventGraph eventGraph = ReflectionUtil.CompileTimeGraph.getEventGraph();
        eventGraph.getConsumers().forEach(StaticEventConsumerInjector::injectOne);
    }

    @NotNull
    public static Set<String> collectEventProducerMixinClassNames() {
        EventGraph eventGraph = ReflectionUtil.CompileTimeGraph.getEventGraph();
        return eventGraph.getProducers().stream().map(EventProducerInfo::getDeclaringClassName).collect(Collectors.toSet());
    }

    private static <T extends BaseEvent> void injectOne(@NotNull EventConsumerInfo eventConsumerInfo) {
        if (!ModuleLoadDeterminer.shouldLoadThis(eventConsumerInfo.getDeclaringClassName())) {
            return;
        }
        if (eventConsumerInfo.isDynamic()) {
            return;
        }
        String eventTypeClassName = eventConsumerInfo.getEventTypeClassName();
        Class<?> eventTypeClass = Class.forName(eventTypeClassName);
        Class<?> eventConsumerDeclaringClass = Class.forName(eventConsumerInfo.getDeclaringClassName());
        Method eventConsumerDeclaringMethod = eventConsumerDeclaringClass.getDeclaredMethod(eventConsumerInfo.getDeclaringMethodName(), eventTypeClass);
        BaseEventConsumer<?> baseEventConsumer = StaticEventConsumer.makeStatic(eventConsumerInfo, eventTypeClass, eventConsumerDeclaringMethod);
        EventManager.registerEventConsumer(eventTypeClass, baseEventConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static Set<String> getEventProducerMixinClassNames() {
        Object $value = eventProducerMixinClassNames.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = eventProducerMixinClassNames;
            synchronized (atomicReference) {
                $value = eventProducerMixinClassNames.get();
                if ($value == null) {
                    Set<String> actualValue = StaticEventConsumerInjector.collectEventProducerMixinClassNames();
                    $value = actualValue == null ? eventProducerMixinClassNames : actualValue;
                    eventProducerMixinClassNames.set($value);
                }
            }
        }
        return (Set)($value == eventProducerMixinClassNames ? null : $value);
    }
}

