/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.gui.component.gui;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.component.gui.PagedGui;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CrudPagedGui<T>
extends PagedGui<T> {
    public CrudPagedGui(@Nullable SimpleGui parent, @NotNull class_3222 player, @NotNull class_2561 prefixTitle, @NotNull List<T> entities, int pageIndex) {
        super(parent, player, prefixTitle, entities, pageIndex);
        if (this.canCreateEntity()) {
            GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 3, (GuiElementBuilder)GuiHelper.Button.makeAddButton(player).setName(TextHelper.getTextByKey(player, "add", new Object[0])).setCallback(this::doCreateEntity));
        }
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 4, GuiHelper.Button.makeHelpButton(player).setLore(TextHelper.getTextListByKey(player, this.getGuiHelpLoreKey())));
    }

    private void doCreateEntity() {
        if (!this.canCreateEntity()) {
            TextHelper.sendTextByKey(this.getPlayer(), "operation.no_permission", new Object[0]);
            return;
        }
        this.onCreateEntity();
    }

    @Override
    @NotNull
    protected final GuiElementInterface toGuiElement(@NotNull T entity) {
        if (!this.canReadEntity(entity)) {
            return new GuiElementBuilder().setItem(class_1802.field_8077).setName(TextHelper.getTextByKey(entity, "no_permission", new Object[0])).build();
        }
        GuiElementBuilder builder = this.toGuiElementBuilder(entity);
        builder.setCallback(this.dispatchClickType(entity));
        return builder.build();
    }

    protected abstract GuiElementBuilder toGuiElementBuilder(T var1);

    @NotNull
    protected abstract String getGuiHelpLoreKey();

    protected abstract void onCreateEntity();

    protected abstract boolean canCreateEntity();

    protected abstract boolean canReadEntity(T var1);

    protected abstract boolean canUpdateEntity(T var1);

    protected abstract boolean canDeleteEntity(T var1);

    private GuiElementInterface.ItemClickCallback dispatchClickType(T entity) {
        return (index, clickType, actionType) -> {
            if (clickType == ClickType.MOUSE_LEFT) {
                this.onLeftClickEntity(entity);
                return;
            }
            if (clickType == ClickType.MOUSE_RIGHT) {
                this.onRightClickEntity(entity);
                return;
            }
            if (clickType == ClickType.MOUSE_LEFT_SHIFT) {
                this.onLeftShiftClickEntity(entity);
                return;
            }
            if (clickType == ClickType.MOUSE_RIGHT_SHIFT) {
                this.onRightShiftClickEntity(entity);
                return;
            }
            if (clickType == ClickType.MOUSE_MIDDLE) {
                this.onMiddleClickEntity(entity);
                return;
            }
        };
    }

    protected void onLeftClickEntity(T entity) {
    }

    protected void onRightClickEntity(T entity) {
    }

    protected void onLeftShiftClickEntity(T entity) {
    }

    protected void onRightShiftClickEntity(T entity) {
    }

    protected void onMiddleClickEntity(T entity) {
    }
}

