/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.gui.component.gui;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ItemStackHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.core.gui.component.gui.InputSignGui;
import io.github.sakurawald.fuji.core.gui.structure.EntityToElementMapping;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PagedGui<T>
extends SimpleGui {
    @Nullable
    private final SimpleGui parent;
    private final List<T> entities;
    private final int pageIndex;
    private final class_2561 prefixTitle;
    protected boolean streamMessageIntoToast = true;
    private final EntityToElementMapping<T> entityToElementMapping = new EntityToElementMapping();
    private boolean openParentGuiWhenClose = true;

    public PagedGui(@Nullable SimpleGui parent, @NotNull class_3222 player, @NotNull class_2561 prefixTitle, @NotNull List<T> entities, int pageIndex) {
        super(class_3917.field_17327, player, false);
        this.parent = parent;
        this.prefixTitle = prefixTitle;
        this.pageIndex = pageIndex;
        this.entities = entities;
    }

    public boolean open() {
        this.drawPagedGui();
        return super.open();
    }

    protected abstract PagedGui<T> makePage(@Nullable SimpleGui var1, @NotNull class_3222 var2, class_2561 var3, @NotNull List<T> var4, int var5);

    private void drawNavigator(int pageIndex) {
        GuiHelper.Placer.fillLastLineIfEmpty((SlotGuiInterface)this, GuiHelper.Button.makeSlotPlaceholderButton());
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 0, (GuiElementBuilder)GuiHelper.Button.makePreviousPageButton(this.getPlayer()).setCallback(() -> this.tryChangePage(pageIndex - 1)));
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, this.getWidth() - 1, (GuiElementBuilder)GuiHelper.Button.makeNextPageButton(this.getPlayer()).setCallback(() -> this.tryChangePage(pageIndex + 1)));
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, this.getWidth() - 2, (GuiElementBuilder)GuiHelper.Button.makeSearchButton(this.getPlayer()).setCallback(this::onSearchButtonClicked));
    }

    private void onSearchButtonClicked() {
        new InputSignGui(this.getPlayer(), null){

            public void onClose() {
                String keyword = this.joinStrings();
                PagedGui.this.linkCurrentGuiAndSearch(keyword).open();
            }
        }.open();
    }

    @TestCase(action="Issue `/fuji` and click `Next Page` button.", targets={"You should see the reimu there, the footer should not be over-drawn."})
    protected void drawPagedGui() {
        this.drawTitle();
        this.drawEntitiesOnThisPage(this.entities);
        this.drawNavigator(this.pageIndex);
    }

    private void drawEntitiesOnThisPage(@NotNull List<T> entities) {
        int slotIndex = 0;
        for (int i = this.getEntityBeginIndex(this.pageIndex); i < this.getEntityEndIndex(this.pageIndex); ++i) {
            T entity = entities.get(i);
            this.setSlot(slotIndex++, this.makeGuiElementAndBindIt(entity));
        }
    }

    private void tryChangePage(int newPageIndex) {
        int entityBeginIndex = this.getEntityBeginIndex(newPageIndex);
        if (entityBeginIndex < 0 || entityBeginIndex >= this.getEntitySize()) {
            return;
        }
        this.makePage(this.parent, this.getPlayer(), this.prefixTitle, this.entities, newPageIndex).open();
    }

    @TestCase(action="Test the `search` button in paged GUI.", targets={"Issue `/fuji`, and search with keyword `a` twice, then close the GUI. The same GUI should not be linked.", "Issue `/fuji`, and search with keyword `afk`, then close the GUI. The different GUI should be linked.", "Issue `/fuji`, and search with keyword `world`, then the GUI elements in other pages should be initialized for this search."})
    @NotNull
    public PagedGui<T> linkCurrentGuiAndSearch(@NotNull String keywords) {
        class_2561 resultTitle = TextHelper.getTextByKey(this.getPlayer(), "gui.search.title", keywords);
        List<T> resultEntities = this.filterEntities(keywords);
        SimpleGui trueParent = this.getBackendGui();
        if (resultEntities.size() == this.getEntitySize()) {
            trueParent = this.parent;
        }
        return this.makePage(trueParent, this.getPlayer(), resultTitle, resultEntities, 0);
    }

    @TestCase(action="Test the `GUI linking` in paged GUI.", targets={"Issue `/fuji`, and click `core` - `About`, then press `Esc` key to close the GUIs.", "Issue `/fuji`, and click the `afk` module, to open the module details GUI, then press `Esc` key to close this GUI.", "Issue `/fuji`, click `Next Page` button twice, and click any module here, then press `Esc` key to close this GUI."})
    @NotNull
    public PagedGui<T> skipCurrentGuiAndSearch(@NotNull Predicate<T> predicate) {
        class_2561 resultTitle = TextHelper.getTextByKey(this.getPlayer(), "gui.search.title", "YOU SHOULD NOT SEE THIS");
        List resultEntities = this.entities.stream().filter(predicate).toList();
        return this.makePage(this.parent, this.getPlayer(), resultTitle, resultEntities, 0);
    }

    @NotNull
    protected abstract GuiElementInterface toGuiElement(@NotNull T var1);

    @NotNull
    private GuiElementInterface makeGuiElementAndBindIt(@NotNull T entity) {
        GuiElementInterface element = this.toGuiElement(entity);
        this.entityToElementMapping.setBinding(entity, element);
        return element;
    }

    protected boolean filterEntity(@NotNull T entity, @NotNull String keyword) {
        return false;
    }

    private boolean combinedFilterEntity(@NotNull T entity, @NotNull String keyword) {
        class_1799 itemStack;
        GuiElementInterface element = this.entityToElementMapping.getBinding(entity);
        if (element == null) {
            element = this.makeGuiElementAndBindIt(entity);
        }
        if (ItemStackHelper.Filter.filterItemStack(itemStack = element.getItemStack(), keyword)) {
            return true;
        }
        return this.filterEntity(entity, keyword);
    }

    private List<T> filterEntities(@NotNull String keyword) {
        return this.entities.stream().filter(entity -> this.combinedFilterEntity(entity, keyword)).collect(Collectors.toList());
    }

    public List<GuiElementInterface> toGuiElements() {
        return this.entities.stream().map(this::makeGuiElementAndBindIt).toList();
    }

    private void drawTitle() {
        class_5250 formatted = this.prefixTitle.method_27661().method_10852(TextHelper.getTextByKey(this.getPlayer(), "gui.page.title", this.getCurrentPageNumber(), this.getMaxPageNumber()));
        this.setTitle((class_2561)formatted);
    }

    private int getEntitySize() {
        return this.entities.size();
    }

    private int getCurrentPageNumber() {
        return this.pageIndex + 1;
    }

    private int getMaxPageNumber() {
        if (this.getEntitySize() == 0) {
            return 1;
        }
        int a = this.getEntitySize();
        int b = this.getEntityPageSize();
        int bias = 0;
        if (a % b != 0) {
            bias = 1;
        }
        return a / b + bias;
    }

    private int getEntityPageSize() {
        return this.getWidth() * this.getHeight() - 9;
    }

    private int getEntityBeginIndex(int pageIndex) {
        return this.getEntityPageSize() * pageIndex;
    }

    private int getEntityEndIndex(int pageIndex) {
        return Math.min(this.getEntityBeginIndex(pageIndex + 1), this.getEntitySize());
    }

    public void onClose() {
        if (this.openParentGuiWhenClose && this.parent != null) {
            this.parent.open();
        }
    }

    public void closeWithoutOpenParentGui() {
        this.openParentGuiWhenClose = false;
        this.close();
    }

    @NotNull
    public SimpleGui getBackendGui() {
        return this;
    }

    @TestCase(action="Issue `/fuji` command, and press `F` key.", targets={"Check the semantics of `SlotGuiInterface#click`, ensure it didn't changed in new version."})
    public boolean click(int index, ClickType type, class_1713 action) {
        GuiElementInterface element = super.getSlot(index);
        if (action.equals((Object)class_1713.field_7791)) {
            this.onSearchButtonClicked();
            return super.onClick(index, type, action, element);
        }
        if (element != null) {
            element.getGuiCallback().click(index, type, action, (SlotGuiInterface)this);
        }
        return super.onClick(index, type, action, element);
    }

    @Nullable
    @Generated
    public SimpleGui getParent() {
        return this.parent;
    }

    @Generated
    public List<T> getEntities() {
        return this.entities;
    }

    @Generated
    public boolean isStreamMessageIntoToast() {
        return this.streamMessageIntoToast;
    }
}

