/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.job.abst;

import io.github.sakurawald.fuji.core.job.abst.BaseJob;
import lombok.Generated;
import org.quartz.JobDataMap;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public abstract class FixedIntervalJob
extends BaseJob {
    public static final int REPEAT_INDEFINITELY = -1;
    private int intervalInMillSeconds;
    private int repeatCount;

    public FixedIntervalJob(String jobGroup, String jobName, JobDataMap jobDataMap, int intervalInMillSeconds, int repeatCount) {
        super(jobGroup, jobName, jobDataMap, false);
        this.intervalInMillSeconds = intervalInMillSeconds;
        this.repeatCount = repeatCount;
    }

    @Override
    public Trigger makeTrigger() {
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.jobName, this.jobGroup);
        SimpleScheduleBuilder scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds((long)this.intervalInMillSeconds);
        if (this.repeatCount == -1) {
            scheduleBuilder.repeatForever();
        } else {
            scheduleBuilder.withRepeatCount(this.repeatCount - 1);
        }
        return triggerBuilder.withSchedule((ScheduleBuilder)scheduleBuilder).build();
    }

    @Generated
    public FixedIntervalJob() {
    }
}

