/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.job.impl;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.job.abst.FixedIntervalJob;
import io.github.sakurawald.fuji.core.manager.Managers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class PlaySoundJob
extends FixedIntervalJob {
    public PlaySoundJob(JobDataMap jobDataMap, int intervalMs, int repeatCount) {
        super(null, null, jobDataMap, intervalMs, repeatCount);
    }

    public static void scheduleJob(final PlaySoundJobSetup setup, final List<class_3222> mentionedPlayers) {
        int intervalMs = setup.interval_ms;
        int repeatCount = setup.repeat_count;
        PlaySoundJob mentionPlayersJob = new PlaySoundJob(new JobDataMap(){
            {
                this.put(List.class.getName(), mentionedPlayers);
                this.put(PlaySoundJobSetup.class.getName(), setup);
            }
        }, intervalMs, repeatCount);
        Managers.getScheduleManager().scheduleJob(mentionPlayersJob);
    }

    public static void scheduleJob(PlaySoundJobSetup setup, class_3222 serverPlayer) {
        PlaySoundJob.scheduleJob(setup, new ArrayList<class_3222>(Collections.singletonList(serverPlayer)));
    }

    public void execute(@NotNull JobExecutionContext context) {
        List players = (List)context.getJobDetail().getJobDataMap().get((Object)List.class.getName());
        PlaySoundJobSetup setup = (PlaySoundJobSetup)context.getJobDetail().getJobDataMap().get((Object)PlaySoundJobSetup.class.getName());
        players.stream().filter(Objects::nonNull).forEach(player -> ServerHelper.executeSync(() -> {
            class_3414 soundEvent = class_3414.method_47908((class_2960)RegistryHelper.makeIdentifierOrThrow(setup.sound));
            class_3419 soundCategory = class_3419.field_15245;
            PlayerHelper.playSound(player, soundEvent, soundCategory, setup.volume, setup.pitch);
        }));
    }

    @Generated
    public PlaySoundJob() {
    }

    public static class PlaySoundJobSetup {
        @Document(id=1751823822772L, value="The `sound` identifier.")
        @NotNull
        public String sound = "entity.experience_orb.pickup";
        public float volume = 100.0f;
        public float pitch = 1.0f;
        @Document(id=1751823830414L, value="The times to play this sound.")
        public int repeat_count = 3;
        @Document(id=1751823834755L, value="The interval between each sound play.")
        public int interval_ms = 1000;

        @NotNull
        @Generated
        public String getSound() {
            return this.sound;
        }

        @Generated
        public float getVolume() {
            return this.volume;
        }

        @Generated
        public float getPitch() {
            return this.pitch;
        }

        @Generated
        public int getRepeat_count() {
            return this.repeat_count;
        }

        @Generated
        public int getInterval_ms() {
            return this.interval_ms;
        }

        @Generated
        public PlaySoundJobSetup setSound(@NotNull String sound) {
            if (sound == null) {
                throw new NullPointerException("sound is marked non-null but is null");
            }
            this.sound = sound;
            return this;
        }

        @Generated
        public PlaySoundJobSetup setVolume(float volume) {
            this.volume = volume;
            return this;
        }

        @Generated
        public PlaySoundJobSetup setPitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        @Generated
        public PlaySoundJobSetup setRepeat_count(int repeat_count) {
            this.repeat_count = repeat_count;
            return this;
        }

        @Generated
        public PlaySoundJobSetup setInterval_ms(int interval_ms) {
            this.interval_ms = interval_ms;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlaySoundJobSetup)) {
                return false;
            }
            PlaySoundJobSetup other = (PlaySoundJobSetup)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getVolume(), other.getVolume()) != 0) {
                return false;
            }
            if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
                return false;
            }
            if (this.getRepeat_count() != other.getRepeat_count()) {
                return false;
            }
            if (this.getInterval_ms() != other.getInterval_ms()) {
                return false;
            }
            String this$sound = this.getSound();
            String other$sound = other.getSound();
            return !(this$sound == null ? other$sound != null : !this$sound.equals(other$sound));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PlaySoundJobSetup;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getVolume());
            result = result * 59 + Float.floatToIntBits(this.getPitch());
            result = result * 59 + this.getRepeat_count();
            result = result * 59 + this.getInterval_ms();
            String $sound = this.getSound();
            result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PlaySoundJob.PlaySoundJobSetup(sound=" + this.getSound() + ", volume=" + this.getVolume() + ", pitch=" + this.getPitch() + ", repeat_count=" + this.getRepeat_count() + ", interval_ms=" + this.getInterval_ms() + ")";
        }

        @Generated
        public PlaySoundJobSetup() {
        }
    }
}

