/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.manager.impl.bossbar.structure;

import io.github.sakurawald.fuji.core.document.annotation.Document;
import lombok.Generated;

public class Interruptible {
    @Document(id=1751823914000L, value="Is this request interruptible?\n")
    private boolean enable;
    @Document(id=1751823921153L, value="The max distance to interrupt this request.\n")
    private double interruptDistance;
    @Document(id=1751823933921L, value="Interrupt this request when player damaged.\n")
    private boolean interruptOnDamaged;
    @Document(id=1751823938547L, value="Interrupt this request if player in combat.\n")
    private boolean interruptInCombat;

    public static Interruptible makeUninterruptible() {
        return new Interruptible(false, 2048.0, false, false);
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public double getInterruptDistance() {
        return this.interruptDistance;
    }

    @Generated
    public boolean isInterruptOnDamaged() {
        return this.interruptOnDamaged;
    }

    @Generated
    public boolean isInterruptInCombat() {
        return this.interruptInCombat;
    }

    @Generated
    public Interruptible setEnable(boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public Interruptible setInterruptDistance(double interruptDistance) {
        this.interruptDistance = interruptDistance;
        return this;
    }

    @Generated
    public Interruptible setInterruptOnDamaged(boolean interruptOnDamaged) {
        this.interruptOnDamaged = interruptOnDamaged;
        return this;
    }

    @Generated
    public Interruptible setInterruptInCombat(boolean interruptInCombat) {
        this.interruptInCombat = interruptInCombat;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Interruptible)) {
            return false;
        }
        Interruptible other = (Interruptible)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (Double.compare(this.getInterruptDistance(), other.getInterruptDistance()) != 0) {
            return false;
        }
        if (this.isInterruptOnDamaged() != other.isInterruptOnDamaged()) {
            return false;
        }
        return this.isInterruptInCombat() == other.isInterruptInCombat();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Interruptible;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        long $interruptDistance = Double.doubleToLongBits(this.getInterruptDistance());
        result = result * 59 + (int)($interruptDistance >>> 32 ^ $interruptDistance);
        result = result * 59 + (this.isInterruptOnDamaged() ? 79 : 97);
        result = result * 59 + (this.isInterruptInCombat() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "Interruptible(enable=" + this.isEnable() + ", interruptDistance=" + this.getInterruptDistance() + ", interruptOnDamaged=" + this.isInterruptOnDamaged() + ", interruptInCombat=" + this.isInterruptInCombat() + ")";
    }

    @Generated
    public Interruptible() {
    }

    @Generated
    public Interruptible(boolean enable, double interruptDistance, boolean interruptOnDamaged, boolean interruptInCombat) {
        this.enable = enable;
        this.interruptDistance = interruptDistance;
        this.interruptOnDamaged = interruptOnDamaged;
        this.interruptInCombat = interruptInCombat;
    }
}

