/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.manager.impl.module;

import io.github.sakurawald.fuji.core.auxiliary.ExceptionUtil;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.manager.abst.BaseManager;
import io.github.sakurawald.fuji.core.manager.impl.module.ModuleLoadDeterminer;
import io.github.sakurawald.fuji.core.manager.impl.module.ModulePathResolver;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.service.MixinService;

public class ModuleManager
extends BaseManager {
    public static final Map<Class<? extends ModuleInitializer>, ModuleInitializer> MODULE_INITIALIZER_BY_CLASS = new HashMap<Class<? extends ModuleInitializer>, ModuleInitializer>();
    public static final Map<String, Class<? extends ModuleInitializer>> MODULE_INITIALIZER_CLASS_BY_MODULE_PATH_STRING = new HashMap<String, Class<? extends ModuleInitializer>>();

    @Override
    public void onInitialize() {
        this.invokeModuleInitializers();
    }

    private void invokeModuleInitializers() {
        ReflectionUtil.CompileTimeGraph.getCompileTimeTxtGraph("module-initializer-graph.txt").forEach(className -> {
            try {
                Class clazz = MixinService.getService().getClassProvider().findClass(className, false);
                String modulePathString = ModulePathResolver.computeModulePathString(className);
                MODULE_INITIALIZER_CLASS_BY_MODULE_PATH_STRING.put(modulePathString, clazz);
                boolean enable = ModuleLoadDeterminer.shouldLoadThis(className);
                if (!enable) {
                    return;
                }
                this.initializeModuleInitializer(clazz);
            }
            catch (Exception e) {
                throw ExceptionUtil.makeReThrownException(e);
            }
        });
    }

    public <T extends ModuleInitializer> void initializeModuleInitializer(@NotNull Class<T> clazz) {
        String className;
        if (!MODULE_INITIALIZER_BY_CLASS.containsKey(clazz) && ModuleLoadDeterminer.shouldLoadThis(className = clazz.getName())) {
            try {
                ModuleInitializer moduleInitializer = (ModuleInitializer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                moduleInitializer.doInitialize();
                MODULE_INITIALIZER_BY_CLASS.put(clazz, moduleInitializer);
            }
            catch (Exception e) {
                String modulePath = ModulePathResolver.computeModulePathString(className);
                LogUtil.error("\n\n[Module Initialization Failed]\n\u25c9 What happened?\nUnfortunately, the module `{}` could not be initialized.\nTo prevent potential data loss or further issues, the server will now shut down.\n\n\u25c9 Which module?\nIt's `{}` module.\n\n\u25c9 What can I do?\n1. Verify that there are no `JSON syntax errors` in the module's configuration files.\n2. Check if any `other mods` are conflicting with `{}` module.\n3. If you do not require the `{}` module, you may disable it in the `config/fuji/config.json` file, then restart your server.\n4. If the issue persists, please open an issue at: https://github.com/sakurawald/fuji/issues\n\n", modulePath, modulePath, modulePath, modulePath);
                throw ExceptionUtil.makeReThrownException(e);
            }
        }
    }

    public void reloadModuleInitializers() {
        MODULE_INITIALIZER_BY_CLASS.values().forEach(ModuleManager::reloadModuleInitializer);
    }

    private static void reloadModuleInitializer(@NotNull ModuleInitializer initializer) {
        try {
            initializer.doReload();
        }
        catch (Exception originalException) {
            String modulePath = ModulePathResolver.computeModulePathString(initializer.getClass().getName());
            LogUtil.error("Failed to re-load the module '{}'.", modulePath);
            throw ExceptionUtil.makeReThrownException(originalException);
        }
    }
}

