/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.manager.impl.module;

import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.mixin.GlobalMixinConfigPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModulePathResolver {
    public static final String CORE_MODULE_PATH_STRING = "core";
    private static final List<String> CORE_MODULE_PATH_LIST = List.of("core");
    private static final Set<String> DECLARED_MODULE_PATH_STRINGS = new HashSet<String>(ReflectionUtil.CompileTimeGraph.getCompileTimeTxtGraph("module-graph.txt"));
    private static final List<Class<?>> MODULE_PACKAGE_PREFIXES = List.of(ModuleInitializer.class, GlobalMixinConfigPlugin.class);
    private static final Map<String, String> CLASS_NAME_2_MODULE_PATH_STRING = new HashMap<String, String>();

    @NotNull
    public static String toModulePathString(@NotNull List<String> modulePathList) {
        return String.join((CharSequence)".", modulePathList);
    }

    @NotNull
    public static List<String> toModulePathList(@NotNull String modulePathString) {
        return Arrays.stream(modulePathString.split("\\.")).toList();
    }

    @NotNull
    public static String computeModulePathString(@NotNull String className) {
        String modulePathString = CLASS_NAME_2_MODULE_PATH_STRING.get(className);
        if (modulePathString != null) {
            return modulePathString;
        }
        String result = ModulePathResolver.toModulePathString(ModulePathResolver.computeModulePathList(className));
        CLASS_NAME_2_MODULE_PATH_STRING.put(className, result);
        return result;
    }

    @NotNull
    private static List<String> computeModulePathList(@NotNull String className) {
        if (DECLARED_MODULE_PATH_STRINGS.isEmpty()) {
            System.out.println("This is the first time to generate the module path graph file.");
        }
        int beginIndex = -1;
        for (Class<?> modulePackagePrefix : MODULE_PACKAGE_PREFIXES) {
            String packageNamePrefix = modulePackagePrefix.getPackageName();
            if (!className.startsWith(packageNamePrefix) || className.equals(modulePackagePrefix.getName())) continue;
            beginIndex = packageNamePrefix.length() + 1;
            break;
        }
        if (beginIndex == -1) {
            return CORE_MODULE_PATH_LIST;
        }
        String classNameSubstring = className.substring(beginIndex);
        int endIndex = classNameSubstring.lastIndexOf(".");
        if (endIndex == -1) {
            return CORE_MODULE_PATH_LIST;
        }
        ArrayList<String> modulePathList = new ArrayList<String>(List.of((classNameSubstring = classNameSubstring.substring(0, endIndex)).split("\\.")));
        if (((String)modulePathList.get(0)).equals(CORE_MODULE_PATH_STRING)) {
            return CORE_MODULE_PATH_LIST;
        }
        String modulePathString = String.join((CharSequence)".", modulePathList);
        while (!DECLARED_MODULE_PATH_STRINGS.contains(modulePathString)) {
            if (modulePathList.isEmpty()) {
                throw new RuntimeException("There is not declared module path string for class %s, did you forget to define it in the main control file model?".formatted(className));
            }
            modulePathList.remove(modulePathList.size() - 1);
            modulePathString = ModulePathResolver.toModulePathString(modulePathList);
        }
        return modulePathList;
    }
}

