/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.manager.impl.task.structure;

import lombok.Generated;

public class GameTask {
    private int remainingRunTicks;
    private Runnable onStart;
    private Runnable onTick;
    private Runnable onEnd;
    private boolean started = false;
    private boolean completed = false;

    public GameTask(int remainingRunTicks) {
        this(remainingRunTicks, () -> {}, () -> {}, () -> {});
    }

    public GameTask(int remainingRunTicks, Runnable onTick) {
        this(remainingRunTicks, onTick, () -> {}, () -> {});
    }

    public GameTask(int remainingRunTicks, Runnable onTick, Runnable onStart, Runnable onEnd) {
        this.remainingRunTicks = remainingRunTicks;
        this.onStart = onStart;
        this.onTick = onTick;
        this.onEnd = onEnd;
    }

    public void onTick() {
        this.decreaseRemainingRunTicks();
        if (!this.started) {
            this.started = true;
            this.onStart.run();
        }
        this.getOnTick().run();
        if (this.remainingRunTicks <= 0) {
            this.onEnd.run();
            this.completed = true;
        }
    }

    public void decreaseRemainingRunTicks() {
        --this.remainingRunTicks;
    }

    @Generated
    public int getRemainingRunTicks() {
        return this.remainingRunTicks;
    }

    @Generated
    public Runnable getOnStart() {
        return this.onStart;
    }

    @Generated
    public Runnable getOnTick() {
        return this.onTick;
    }

    @Generated
    public Runnable getOnEnd() {
        return this.onEnd;
    }

    @Generated
    public boolean isStarted() {
        return this.started;
    }

    @Generated
    public boolean isCompleted() {
        return this.completed;
    }

    @Generated
    public GameTask setRemainingRunTicks(int remainingRunTicks) {
        this.remainingRunTicks = remainingRunTicks;
        return this;
    }

    @Generated
    public GameTask setOnStart(Runnable onStart) {
        this.onStart = onStart;
        return this;
    }

    @Generated
    public GameTask setOnTick(Runnable onTick) {
        this.onTick = onTick;
        return this;
    }

    @Generated
    public GameTask setOnEnd(Runnable onEnd) {
        this.onEnd = onEnd;
        return this;
    }

    @Generated
    public GameTask setStarted(boolean started) {
        this.started = started;
        return this;
    }

    @Generated
    public GameTask setCompleted(boolean completed) {
        this.completed = completed;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GameTask)) {
            return false;
        }
        GameTask other = (GameTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRemainingRunTicks() != other.getRemainingRunTicks()) {
            return false;
        }
        if (this.isStarted() != other.isStarted()) {
            return false;
        }
        if (this.isCompleted() != other.isCompleted()) {
            return false;
        }
        Runnable this$onStart = this.getOnStart();
        Runnable other$onStart = other.getOnStart();
        if (this$onStart == null ? other$onStart != null : !this$onStart.equals(other$onStart)) {
            return false;
        }
        Runnable this$onTick = this.getOnTick();
        Runnable other$onTick = other.getOnTick();
        if (this$onTick == null ? other$onTick != null : !this$onTick.equals(other$onTick)) {
            return false;
        }
        Runnable this$onEnd = this.getOnEnd();
        Runnable other$onEnd = other.getOnEnd();
        return !(this$onEnd == null ? other$onEnd != null : !this$onEnd.equals(other$onEnd));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GameTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRemainingRunTicks();
        result = result * 59 + (this.isStarted() ? 79 : 97);
        result = result * 59 + (this.isCompleted() ? 79 : 97);
        Runnable $onStart = this.getOnStart();
        result = result * 59 + ($onStart == null ? 43 : $onStart.hashCode());
        Runnable $onTick = this.getOnTick();
        result = result * 59 + ($onTick == null ? 43 : $onTick.hashCode());
        Runnable $onEnd = this.getOnEnd();
        result = result * 59 + ($onEnd == null ? 43 : $onEnd.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GameTask(remainingRunTicks=" + this.getRemainingRunTicks() + ", onStart=" + String.valueOf(this.getOnStart()) + ", onTick=" + String.valueOf(this.getOnTick()) + ", onEnd=" + String.valueOf(this.getOnEnd()) + ", started=" + this.isStarted() + ", completed=" + this.isCompleted() + ")";
    }
}

