/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.service.display.gui;

import com.google.errorprone.annotations.Keep;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.service.display.gui.BaseDisplayGuiFactory;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShulkerBoxDisplayGuiFactory
extends BaseDisplayGuiFactory {
    @Keep
    private static final int SHULKER_BOX_MAX_CAPACITY = 27;
    @NotNull
    private final class_1799 shulkerBoxStack;
    @Nullable
    private final SimpleGui parentGui;

    public ShulkerBoxDisplayGuiFactory(class_2561 title, @NotNull class_1799 shulkerBoxStack, @Nullable SimpleGui parentGui) {
        super(title);
        this.shulkerBoxStack = shulkerBoxStack;
        this.parentGui = parentGui;
    }

    public ShulkerBoxDisplayGuiFactory(class_3222 sourcePlayer, @NotNull class_1799 shulkerBoxStack, @Nullable SimpleGui parentGui) {
        super(sourcePlayer);
        this.shulkerBoxStack = shulkerBoxStack;
        this.parentGui = parentGui;
    }

    @NotNull
    private static Stream<class_1799> extractItemsFromShulkerBox(class_1799 stack) {
        class_9288 containerComponent = (class_9288)stack.method_57824(class_9334.field_49622);
        if (containerComponent == null) {
            return Stream.empty();
        }
        return containerComponent.method_57489();
    }

    @Override
    @NotNull
    public SimpleGui build(class_3222 viewingPlayer) {
        SimpleGui gui = new SimpleGui(class_3917.field_18666, viewingPlayer, false);
        gui.setTitle(this.title);
        for (int i = 0; i < 9; ++i) {
            gui.setSlot(i, GuiHelper.Button.makeSlotPlaceholderButton().getItemStack());
        }
        gui.setSlot(4, this.shulkerBoxStack);
        if (this.parentGui != null) {
            gui.setSlot(8, GuiHelper.Button.makeBackButton(viewingPlayer).setCallback(() -> ((SimpleGui)this.parentGui).open()));
        }
        Stream<class_1799> containerStream = ShulkerBoxDisplayGuiFactory.extractItemsFromShulkerBox(this.shulkerBoxStack);
        Object counter = new Object(this){
            private int offset = 0;
        };
        containerStream.forEach(arg_0 -> ShulkerBoxDisplayGuiFactory.lambda$build$0(gui, counter, arg_0));
        return gui;
    }

    private static /* synthetic */ void lambda$build$0(SimpleGui gui, 1 counter, class_1799 item) {
        gui.setSlot(9 + counter.offset, item.method_7972());
        ++counter.offset;
    }
}

