/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.service.duration_parser;

import io.github.sakurawald.fuji.core.auxiliary.ChronosUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DurationParser {
    private static final int SECOND_TO_SECOND = 1;
    private static final int MINUTE_TO_SECOND = 60;
    private static final int HOUR_TO_SECOND = 3600;
    private static final int DAY_TO_SECOND = 86400;
    private static final int WEEK_TO_SECOND = 604800;
    private static final int MONTH_TO_SECOND = 2592000;
    private static final int YEAR_TO_SECOND = 31104000;
    private static final Pattern DURATION_PARSER_DSL = Pattern.compile("(\\d+)([smhdwMy])");

    public static Optional<Date> parseIntoExpirationDate(@NotNull String inputString) {
        return DurationParser.parseIntoSeconds(inputString).map(seconds -> {
            Calendar nowCalendar = Calendar.getInstance();
            nowCalendar.add(13, (int)seconds);
            return Optional.of(nowCalendar.getTime());
        }).orElseGet(Optional::empty);
    }

    public static Optional<Long> parseIntoExpirationTimestamp(@Nullable String inputString) {
        if (inputString == null) {
            return Optional.empty();
        }
        return DurationParser.parseIntoExpirationDate(inputString).map(ChronosUtil::toTimestamp);
    }

    public static Optional<Integer> parseIntoSeconds(@NotNull String inputString) {
        Matcher matcher = DURATION_PARSER_DSL.matcher(inputString);
        int seconds = 0;
        while (matcher.find()) {
            String unit;
            int quantity = Integer.parseInt(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "s": {
                    seconds += quantity * 1;
                    break;
                }
                case "m": {
                    seconds += quantity * 60;
                    break;
                }
                case "h": {
                    seconds += quantity * 3600;
                    break;
                }
                case "d": {
                    seconds += quantity * 86400;
                    break;
                }
                case "w": {
                    seconds += quantity * 604800;
                    break;
                }
                case "M": {
                    seconds += quantity * 2592000;
                    break;
                }
                case "y": {
                    seconds += quantity * 31104000;
                }
            }
        }
        if (seconds == 0) {
            return Optional.empty();
        }
        return Optional.of(seconds);
    }

    @NotNull
    public static String formatMillSeconds(long millSeconds) {
        return DurationParser.formatSeconds((int)(millSeconds / 1000L));
    }

    @NotNull
    public static String formatSeconds(int totalSeconds) {
        int seconds;
        if (totalSeconds < 0) {
            throw new IllegalArgumentException("Seconds must be non-negative");
        }
        StringBuilder result = new StringBuilder();
        int years = totalSeconds / 31104000;
        totalSeconds %= 31104000;
        if (years > 0) {
            result.append(years).append("y");
        }
        int months = totalSeconds / 2592000;
        totalSeconds %= 2592000;
        if (months > 0) {
            result.append(months).append("M");
        }
        int weeks = totalSeconds / 604800;
        totalSeconds %= 604800;
        if (weeks > 0) {
            result.append(weeks).append("w");
        }
        int days = totalSeconds / 86400;
        totalSeconds %= 86400;
        if (days > 0) {
            result.append(days).append("d");
        }
        int hours = totalSeconds / 3600;
        totalSeconds %= 3600;
        if (hours > 0) {
            result.append(hours).append("h");
        }
        int minutes = totalSeconds / 60;
        totalSeconds %= 60;
        if (minutes > 0) {
            result.append(minutes).append("m");
        }
        if ((seconds = totalSeconds) > 0 || result.isEmpty()) {
            result.append(seconds).append("s");
        }
        return result.toString();
    }
}

