/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.service.duration_parser.command.argument.adapter;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import io.github.sakurawald.fuji.core.command.argument.structure.CommandArgument;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.service.duration_parser.DurationParser;
import io.github.sakurawald.fuji.core.service.duration_parser.command.argument.wrapper.Duration;
import java.util.List;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

public class DurationArgumentTypeAdapter
extends BaseArgumentTypeAdapter {
    @Override
    protected ArgumentType<?> makeArgumentType() {
        return StringArgumentType.string();
    }

    @Override
    protected Object makeArgumentValue(@NotNull CommandContext<class_2168> context, @NotNull CommandArgument commandArgument) {
        String durationString = StringArgumentType.getString(context, (String)commandArgument.getArgumentName());
        return DurationParser.parseIntoSeconds(durationString).map(it -> new Duration(durationString)).orElseThrow(() -> {
            TextHelper.sendTextByKey(context.getSource(), "duration.invalid", durationString);
            return new AbortCommandExecutionException();
        });
    }

    @Override
    public List<Class<?>> getTypeClasses() {
        return List.of(Duration.class);
    }

    @Override
    public List<String> getTypeNames() {
        return List.of("duration");
    }

    @Override
    @NotNull
    protected RequiredArgumentBuilder<class_2168, ?> makeRequiredArgumentBuilder(@NotNull String argumentName) {
        return super.makeRequiredArgumentBuilder(argumentName).suggests(CommandHelper.Suggestion.iterable(() -> List.of("30m", "12h", "1d", "3d", "1w", "1M")));
    }
}

