/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.service.random_teleport.filter;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.service.random_teleport.structure.RandomTeleportSettings;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class PositionFilter {
    public static final Set<class_2248> KNOWN_DANGEROUS_BLOCKS = Set.of(class_2246.field_27879, class_2246.field_10092, class_2246.field_10036, class_2246.field_16999, class_2246.field_10029, class_2246.field_10243, class_2246.field_17350);

    public static boolean isYInRange(@NotNull RandomTeleportSettings settings, @NotNull class_2338 blockPos) {
        return blockPos.method_10264() >= settings.getMinY() && blockPos.method_10264() <= settings.getMaxY();
    }

    public static boolean isInsideWorldBorder(@NotNull class_3218 world, @NotNull class_2338 blockPos) {
        return world.method_8621().method_11952(blockPos);
    }

    public static boolean isSafeBlock(@NotNull RandomTeleportSettings settings, @NotNull class_2680 blockState) {
        String blockId = RegistryHelper.getIdAsString(blockState);
        return PositionFilter.isSafeBlock(blockState) && !settings.getBlocks().getSkip().contains(blockId);
    }

    public static boolean isSafeBlock(@NotNull class_2680 blockState) {
        return !PositionFilter.isLiquidBlock(blockState) && !KNOWN_DANGEROUS_BLOCKS.contains(blockState.method_26204());
    }

    private static boolean isLiquidBlock(@NotNull class_2680 blockState) {
        return !blockState.method_26227().method_15769();
    }
}

