/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.service.toast_sender;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_178;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2062;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2779;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import org.jetbrains.annotations.NotNull;

public class ToastSender {
    private static final String IMPOSSIBLE = "impossible";
    private static final String DUMMY_RESOURCE_IMAGE_IDENTIFIER = "minecraft:textures/gui/advancements/backgrounds/end.png";
    private static final class_2960 SEND_TOAST_IDENTIFIER = class_2960.method_60655((String)"custom", (String)"custom");

    public static void sendToast(@NotNull class_3222 player, @NotNull class_189 advancementFrame, @NotNull class_1799 icon, @NotNull class_2561 title) {
        class_185 advancementDisplay = new class_185(icon, title, (class_2561)class_2561.method_43473(), Optional.of(RegistryHelper.makeIdentifierOrThrow(DUMMY_RESOURCE_IMAGE_IDENTIFIER)), advancementFrame, true, false, true);
        class_8779 advancementEntry = class_161.class_162.method_707().method_693(advancementDisplay).method_706(class_170.field_1167).method_34884(ToastSender.makeAdvancementRequirements()).method_705(IMPOSSIBLE, ToastSender.makeAdvancementCriterion()).method_695(SEND_TOAST_IDENTIFIER);
        player.field_13987.method_14364((class_2596)ToastSender.makeGrantPacket(advancementEntry, SEND_TOAST_IDENTIFIER));
        player.field_13987.method_14364((class_2596)ToastSender.makeRevokePacket(SEND_TOAST_IDENTIFIER));
    }

    private static class_175<class_2062.class_2063> makeAdvancementCriterion() {
        class_175 advancementCriterion = new class_2062().method_53699((class_184)new class_2062.class_2063());
        return advancementCriterion;
    }

    private static class_8782 makeAdvancementRequirements() {
        return new class_8782(List.of(List.of(IMPOSSIBLE)));
    }

    private static class_167 makeAdvancementProgress() {
        class_167 advancementProgress = new class_167();
        advancementProgress.method_727(ToastSender.makeAdvancementRequirements());
        return advancementProgress;
    }

    @NotNull
    private static class_2779 makeGrantPacket(class_8779 advancementEntry, class_2960 identifier) {
        class_167 advancementProgress = ToastSender.makeAdvancementProgress();
        class_178 criterionProgress = advancementProgress.method_737(IMPOSSIBLE);
        if (criterionProgress == null) {
            LogUtil.error("It's strange that the statement `advancementProgress.getCriterionProgress(IMPOSSIBLE)` is null, aborting this advancement packet making.", new Object[0]);
            throw new AbortCommandExecutionException();
        }
        criterionProgress.method_789();
        List<class_8779> toEarn = List.of(advancementEntry);
        Set<class_2960> toRemove = Set.of();
        Map<class_2960, class_167> toSetProgress = Map.of(identifier, advancementProgress);
        return ToastSender.makeAdvancementUpdatePacket(toEarn, toRemove, toSetProgress);
    }

    private static class_2779 makeAdvancementUpdatePacket(Collection<class_8779> toEarn, Set<class_2960> toRemove, Map<class_2960, class_167> toSetProgress) {
        return new class_2779(false, toEarn, toRemove, toSetProgress);
    }

    @NotNull
    private static class_2779 makeRevokePacket(class_2960 identifier) {
        List<class_8779> toEarn = List.of();
        Set<class_2960> toRemove = Set.of(identifier);
        Map<class_2960, class_167> toSetProgress = Map.of();
        return ToastSender.makeAdvancementUpdatePacket(toEarn, toRemove, toSetProgress);
    }
}

