/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.structure;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_1657;
import org.jetbrains.annotations.NotNull;

@Document(id=1756103268606L, value="You can attach a named `tag` to an `entity`.\nThen reference this entity using the `tag` name.\n")
public class Tags
extends ArrayList<String> {
    private static final Map<String, PermissionDescriptor> CREATED_TAG_KIND_PERMISSIONS = new HashMap<String, PermissionDescriptor>();

    public static Tags makeDefault() {
        Tags tags = new Tags();
        tags.add("default-tag-name");
        return tags;
    }

    @DocStringProvider(id=1751998842298L, value="Having this `permission`, means having the specified named `tag` for this `tag kind`.\n")
    @NotNull
    private static PermissionDescriptor getOrCreateTagPermission(@NotNull String tagKind) {
        return CREATED_TAG_KIND_PERMISSIONS.computeIfAbsent(tagKind, k -> {
            String pattern = "fuji.%s.<tag-name>";
            pattern = pattern.formatted(tagKind);
            return new PermissionDescriptor(pattern, 1751998842298L);
        });
    }

    public static boolean hasAnyTagPermission(@NotNull class_1657 player, String tagKind, Tags tags) {
        boolean result = false;
        for (String tag : tags) {
            PermissionDescriptor permission = Tags.getOrCreateTagPermission(tagKind);
            if (!LuckpermsHelper.hasPermission(player.method_5667(), permission, tagKind, tag)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Tags()";
    }

    @Generated
    public Tags() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tags)) {
            return false;
        }
        Tags other = (Tags)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Tags;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

