/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.afk;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.annotation.CommandTarget;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.afk.config.model.AfkConfigModel;
import io.github.sakurawald.fuji.module.initializer.afk.service.AfkService;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1751826238005L, value="This module provides:\n1. Afk detection: If a player idle too long, we will mark it as afk state.\n2. Afk event: Execute commands when a player enters or leaves afk state.\n3. Afk name customization: For a afk player, we can customize its display name in tab list.\n")
@ColorBox(id=1751870451351L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\n\nFor each player, define a `number` to track `the last action time`.\nActions can be: `mine a block`, `movement`, `issue a command` ...\nWhen action received, update the number.\nDefine a `job` using cron, to be triggered periodically.\nThe job will check and compare 2 consecutive value of the `number`.\nIf number is identical, then the player is considered as in `afk`.\n")
public class AfkInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<AfkConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", AfkConfigModel.class);

    @CommandNode(value="afk")
    @Document(id=1751826266551L, value="Enter afk state.")
    private static int $afk(@CommandSource @CommandTarget class_3222 player) {
        if (!AfkService.canEnterAfk(player)) {
            TextHelper.sendTextByKey(player, "afk.on.failed", new Object[0]);
            return 0;
        }
        AfkService.changeAfk(player, true);
        TextHelper.sendTextByKey(player, "afk.on", new Object[0]);
        return 1;
    }

    @Document(id=1751826271499L, value="Test if a player is in afk state.")
    @CommandNode(value="is-afk?")
    @CommandRequirement(level=4)
    private static int $isAfk(@CommandSource class_2168 source, class_3222 player) {
        boolean value = AfkService.isAfk(player);
        return CommandHelper.Return.returnBoolean(source, value);
    }
}

