/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.back.service;

import io.github.sakurawald.fuji.core.auxiliary.ChronosUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.Dimension;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerDeathEvent;
import io.github.sakurawald.fuji.core.event.message.player.PlayerTeleportPreEvent;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import io.github.sakurawald.fuji.module.initializer.back.BackInitializer;
import io.github.sakurawald.fuji.module.initializer.back.structure.LocationEntry;
import io.github.sakurawald.fuji.module.initializer.back.structure.LocationHistory;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackService {
    public static <R> R withLocationHistory(@NotNull class_3222 player, Function<LocationHistory, R> function) {
        String playerName = player.method_7334().getName();
        BackInitializer.savedPositionConfig.model().player2history.computeIfAbsent(playerName, k -> new LocationHistory());
        LocationHistory locationHistory = BackInitializer.savedPositionConfig.model().player2history.get(playerName);
        return function.apply(locationHistory);
    }

    public static Integer listBackLocations(class_2168 source, class_3222 player) {
        return BackService.withLocationHistory(player, locationHistory -> {
            String targetPlayerName = player.method_7334().getName();
            TextHelper.sendTextByKey(source, "back.list", targetPlayerName);
            locationHistory.listEntries().forEachRemaining(it -> {
                GlobalPos location = it.getLocation();
                TextHelper.sendTextByKey(source, "back.list.entry", location.getLevel(), location.getX(), location.getY(), location.getZ(), ChronosUtil.Formatter.formatDate(it.getSavedTimestamp()));
            });
            return 1;
        });
    }

    public static int teleportBackLocation(@NotNull class_3222 player, int lastNLocation, @Nullable Dimension targetDimension) {
        return BackService.withLocationHistory(player, locationHistory -> {
            LocationEntry latestEntry = locationHistory.findEntry(lastNLocation, targetDimension);
            if (latestEntry == null) {
                TextHelper.sendTextByKey(player, "back.no_previous_position", new Object[0]);
                throw new AbortCommandExecutionException();
            }
            latestEntry.getLocation().teleport(player);
            return 1;
        });
    }

    private static int getMaxBackLocationEntriesToSave(@NotNull class_3222 player) {
        Optional<Integer> value = LuckpermsHelper.getMeta(player.method_5667(), BackInitializer.MAX_LOCATION_ENTRIES_TO_SAVE_META, new Object[0]);
        return value.orElse(BackInitializer.config.model().max_back_location_entries_to_save);
    }

    private static boolean shouldSaveCurrentLocation(@NotNull class_3222 player) {
        return BackService.withLocationHistory(player, locationHistory -> {
            LocationEntry latestEntry = locationHistory.getLatestEntry();
            if (latestEntry == null) {
                return true;
            }
            GlobalPos latestLocation = latestEntry.getLocation();
            double ignoreDistance = BackInitializer.config.model().ignore_distance;
            if (latestLocation.sameLevel(player.method_37908()) && player.method_19538().method_1028(latestLocation.getX(), latestLocation.getY(), latestLocation.getZ()) <= ignoreDistance * ignoreDistance) {
                return false;
            }
            return true;
        });
    }

    private static void trySaveCurrentLocation(@NotNull class_3222 player) {
        BackService.withLocationHistory(player, locationHistory -> {
            if (BackService.shouldSaveCurrentLocation(player)) {
                LocationEntry locationEntry = LocationEntry.makeLocationEntry(player);
                BackService.pushBackLocation(player, locationHistory, locationEntry);
            }
            return null;
        });
    }

    public static void pushBackLocation(@NotNull class_3222 player, @NotNull LocationHistory locationHistory, @NotNull LocationEntry locationEntry) {
        locationHistory.pushEntry(locationEntry);
        locationHistory.trimEntries(BackService.getMaxBackLocationEntriesToSave(player));
    }

    @EventConsumer
    private static void handleOnPlayerDeathEvent(PlayerDeathEvent event) {
        if (BackInitializer.config.model().enable_back_on_death) {
            BackService.trySaveCurrentLocation(event.getPlayer());
        }
    }

    @EventConsumer
    private static void handlePlayerPreTeleportEvent(PlayerTeleportPreEvent event) {
        if (event.getCallbackInfo().isCancelled()) {
            return;
        }
        if (BackInitializer.config.model().enable_back_on_teleport) {
            BackService.trySaveCurrentLocation(event.getPlayer());
        }
    }
}

