/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.chat.history;

import com.google.common.collect.EvictingQueue;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerChatMessageSentEvent;
import io.github.sakurawald.fuji.core.event.message.player.PlayerJoinedEvent;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.chat.history.config.model.ChatHistoryConfigModel;
import java.util.Queue;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7471;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826684077L, value="This module will store chat message as history.\nAnd send them to the player joined the server.\n")
@ColorBox(id=1751870560992L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 This module works with `Styled Chat` mod.\nYou can use this module to provide the `chat history` for it.\n")
public class ChatHistoryInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ChatHistoryConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", ChatHistoryConfigModel.class);
    private static Queue<class_2561> chatHistory;

    private static boolean isMessageTypeAccepted(@NotNull String messageTypeAsString) {
        boolean acceptedMessageType = false;
        if (config.model().getMessageTypeAcceptors().stream().anyMatch(messageTypeAsString::equals)) {
            acceptedMessageType = true;
        }
        if (!acceptedMessageType) {
            LogUtil.debug("There is no an acceptor defined to accept the message type {}, ignoring it for the chat history.", messageTypeAsString);
        }
        return acceptedMessageType;
    }

    private static boolean isMessageRejected(@NotNull String contentString, @NotNull String parametersString) {
        LogUtil.debug("content = {}, parameters = {}", contentString, parametersString);
        boolean rejectedMessage = false;
        if (config.model().getMessageRejectors().getContentRejector().getMatches().stream().anyMatch(contentString::matches)) {
            rejectedMessage = true;
        }
        if (config.model().getMessageRejectors().getParameterRejector().getMatches().stream().anyMatch(parametersString::matches)) {
            rejectedMessage = true;
        }
        if (rejectedMessage) {
            LogUtil.debug("One defined rejector REJECTS a message, ignoring it for the chat history: content = {}, parameters = {}", contentString, parametersString);
        }
        return rejectedMessage;
    }

    private static void processChatHistory(@NotNull class_7471 signedMessage, @NotNull class_2556.class_7602 parameters) {
        String parametersString;
        String messageTypeString = RegistryHelper.getIdAsString(parameters);
        if (!ChatHistoryInitializer.isMessageTypeAccepted(messageTypeString)) {
            return;
        }
        String contentString = TextHelper.Operators.getString(signedMessage.method_46291());
        if (ChatHistoryInitializer.isMessageRejected(contentString, parametersString = parameters.toString())) {
            return;
        }
        class_2561 decoratedTextAsTheClientSideDo = parameters.method_44837(signedMessage.method_46291());
        ChatHistoryInitializer.storeChatHistory(decoratedTextAsTheClientSideDo);
    }

    @Override
    protected void onInitialize() {
        chatHistory = EvictingQueue.create((int)config.model().getBufferSize());
    }

    @Override
    protected void onReload() {
        EvictingQueue newQueue = EvictingQueue.create((int)config.model().getBufferSize());
        newQueue.addAll(chatHistory);
        chatHistory.clear();
        chatHistory = newQueue;
    }

    private static void storeChatHistory(@NotNull class_2561 text) {
        chatHistory.add(text);
    }

    @EventConsumer(injectorPriority=0, consumerPriority=0)
    private static void replayChatHistory(PlayerJoinedEvent event) {
        class_3222 player = event.getPlayer();
        chatHistory.forEach(text -> TextHelper.sendMessageByText(player, text));
    }

    @EventConsumer(injectorPriority=2000, consumerPriority=2000)
    private static void consumePlayerChatMessageSentEvent(PlayerChatMessageSentEvent event) {
        ChatHistoryInitializer.processChatHistory(event.getSignedMessage(), event.getParameters());
    }
}

