/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.cleaner.service;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.WorldHelper;
import io.github.sakurawald.fuji.core.service.type_formatter.TypeFormatter;
import io.github.sakurawald.fuji.module.initializer.cleaner.CleanerInitializer;
import io.github.sakurawald.fuji.module.initializer.cleaner.config.model.CleanerConfigModel;
import io.github.sakurawald.fuji.module.initializer.cleaner.structure.CleanerMatcher;
import io.github.sakurawald.fuji.module.initializer.cleaner.structure.CleanupMethod;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanerService {
    private static boolean shouldIgnoreEntity(@Nullable class_1297 entity) {
        if (entity == null) {
            return true;
        }
        if (entity.method_5864().equals(class_1299.field_6097)) {
            return true;
        }
        CleanerConfigModel.Ignore config = CleanerInitializer.config.model().getIgnore();
        if (config.isIgnoreItemEntity() && EntityHelper.isItemEntity(entity)) {
            return true;
        }
        if (config.isIgnoreLivingEntity() && EntityHelper.isLivingEntity(entity)) {
            return true;
        }
        if (config.isIgnoreNamedEntity() && EntityHelper.hasCustomName(entity)) {
            return true;
        }
        if (config.isIgnoreEntityWithVehicle() && EntityHelper.hasVehicle(entity)) {
            return true;
        }
        if (config.isIgnoreEntityWithPassengers() && EntityHelper.hasPassengers(entity)) {
            return true;
        }
        if (config.isIgnoreLeashedEntity() && EntityHelper.isLeashed(entity)) {
            return true;
        }
        return config.isIgnoreGlowingEntity() && EntityHelper.isGlowing(entity);
    }

    private static Optional<CleanerMatcher> findApplicableMatcher(@NotNull String entityKey, int age) {
        return CleanerInitializer.config.model().getMatchers().stream().filter(CleanerMatcher::isEnable).filter(it -> it.isMatch(entityKey, age)).findFirst();
    }

    private static void cleanEntity(@NotNull class_1297 entity, @NotNull CleanerMatcher matcher) {
        if (matcher.getCleanupMethod().equals((Object)CleanupMethod.KILL)) {
            EntityHelper.killEntity(entity);
            return;
        }
        if (matcher.getCleanupMethod().equals((Object)CleanupMethod.DISCARD)) {
            entity.method_31472();
            return;
        }
    }

    public static void cleanEntities() {
        HashMap<String, Integer> cleanedEntities = new HashMap<String, Integer>();
        for (class_3218 world : WorldHelper.getWorlds()) {
            for (class_1297 entity : world.method_27909()) {
                if (CleanerService.shouldIgnoreEntity(entity)) continue;
                String entityKey = EntityHelper.toTranslatableKey(entity);
                int entityCount = EntityHelper.getEntityEffectiveCount(entity);
                CleanerService.findApplicableMatcher(entityKey, entity.field_6012).ifPresent(matcher -> {
                    cleanedEntities.merge(entityKey, entityCount, Integer::sum);
                    CleanerService.cleanEntity(entity, matcher);
                });
            }
        }
        CleanerService.sendCleanerBroadcast(cleanedEntities);
    }

    private static void sendCleanerBroadcast(@NotNull Map<String, Integer> cleanedEntitiesMap) {
        if (cleanedEntitiesMap.isEmpty()) {
            return;
        }
        int cleanedEntitiesCount = cleanedEntitiesMap.values().stream().mapToInt(Integer::intValue).sum();
        LogUtil.info("Cleaned entities: {}", cleanedEntitiesMap);
        class_5250 hoverText = class_2561.method_43473().method_27692(class_124.field_1065).method_10852(TypeFormatter.formatTypes(null, cleanedEntitiesMap));
        PlayerHelper.Lookup.getOnlinePlayers().forEach(arg_0 -> CleanerService.lambda$sendCleanerBroadcast$2(cleanedEntitiesCount, (class_2561)hoverText, arg_0));
    }

    private static /* synthetic */ void lambda$sendCleanerBroadcast$2(int cleanedEntitiesCount, class_2561 hoverText, class_3222 player) {
        class_5250 reportText = class_2561.method_43473().method_10852(TextHelper.getTextByKey(player, "cleaner.broadcast", cleanedEntitiesCount)).method_27696(class_2583.field_24360.method_10949(TextHelper.Events.HoverEvent.makeShowTextAction(hoverText)));
        TextHelper.sendMessageByText(player, (class_2561)reportText);
    }
}

