/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_cooldown;

import io.github.sakurawald.fuji.core.auxiliary.ChronosUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlaceholderHelper;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.descriptor.PlaceholderDescriptor;
import io.github.sakurawald.fuji.core.service.duration_parser.DurationParser;
import io.github.sakurawald.fuji.module.initializer.command_cooldown.service.NamedCooldownService;
import io.github.sakurawald.fuji.module.initializer.command_cooldown.structure.NamedCooldownDataNode;
import io.github.sakurawald.fuji.module.initializer.command_cooldown.structure.NamedCooldownDescriptor;
import java.util.function.Function;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandCooldownPlaceholders {
    private static class_2561 makeUnknownNamedCooldownText(String cooldownName) {
        return class_2561.method_43470((String)"[Unknown named-cooldown: %s]".formatted(cooldownName));
    }

    private static class_2561 mapNamedCooldownDataNodeIntoText(@Nullable String args, @NotNull Function<NamedCooldownDataNode, class_2561> mapper) {
        NamedCooldownDescriptor cooldownDescriptor = NamedCooldownService.getNamedCooldownDescriptors().get(args);
        if (cooldownDescriptor == null) {
            return CommandCooldownPlaceholders.makeUnknownNamedCooldownText(args);
        }
        return NamedCooldownService.withNamedCooldownDataNode(cooldownDescriptor, mapper);
    }

    @DocStringProvider(id=1751999791863L, value="Returns the `remaining available uses` for `specified named cooldown` in integer.\n\nFor example, if you have a `named cooldown` whose name is `kitfood`.\nYou can use: `%fuji:command_cooldown_left_usage kitfood%`\n")
    static void registerCommandCooldownLeftUsagePlaceholder() {
        PlaceholderDescriptor placeholderDescriptor = new PlaceholderDescriptor("command_cooldown_left_usage", 1751999791863L);
        PlaceholderHelper.registerPlayerPlaceholder(placeholderDescriptor, (player, args) -> CommandCooldownPlaceholders.mapNamedCooldownDataNodeIntoText(args, dataNode -> {
            String key = NamedCooldownDataNode.toKey(player);
            int uses = dataNode.getUses().computeIfAbsent(key, k -> 0);
            int availableUses = dataNode.getDescriptor().getMaxUses() - uses;
            return class_2561.method_43470((String)String.valueOf(availableUses));
        }));
    }

    @DocStringProvider(id=1751999769680L, value="Returns the `remaining cooldown duration` for `specified named cooldown` in `1d2h3m4s` format.\n\nFor example, if you have a `named cooldown` whose name is `kitfood`.\nYou can use: `%fuji:command_cooldown_left_time kitfood%`\n")
    static void registerCommandCooldownLeftTimePlaceholder() {
        PlaceholderDescriptor placeholderDescriptor = new PlaceholderDescriptor("command_cooldown_left_time", 1751999769680L);
        PlaceholderHelper.registerPlayerPlaceholder(placeholderDescriptor, (player, args) -> CommandCooldownPlaceholders.mapNamedCooldownDataNodeIntoText(args, dataNode -> {
            String key = NamedCooldownDataNode.toKey(player);
            long remainingDuration = dataNode.getRemainingTime(key, dataNode.getDescriptor().getCooldownDuration());
            remainingDuration = Math.max(0L, remainingDuration);
            String formattedRemainingDuration = DurationParser.formatMillSeconds(remainingDuration);
            return class_2561.method_43470((String)formattedRemainingDuration);
        }));
    }

    @DocStringProvider(id=1752625269482L, value="Returns the `next available date` for `specified named cooldown`.\n\nFor example, if you have a `named cooldown` whose name is `kitfood`.\nYou can use: `%fuji:command_cooldown_left_time_date kitfood%`\n")
    static void registerCommandCooldownLeftTimeDatePlaceholder() {
        PlaceholderDescriptor placeholderDescriptor = new PlaceholderDescriptor("command_cooldown_left_time_date", 1752625269482L);
        PlaceholderHelper.registerPlayerPlaceholder(placeholderDescriptor, (player, args) -> CommandCooldownPlaceholders.mapNamedCooldownDataNodeIntoText(args, dataNode -> {
            String key = NamedCooldownDataNode.toKey(player);
            long nextAvailableDate = dataNode.getCooldown().getLastUseTime(key) + dataNode.getDescriptor().getCooldownDuration();
            String formattedLeftTime = ChronosUtil.Formatter.formatDate(nextAvailableDate);
            return class_2561.method_43470((String)formattedLeftTime);
        }));
    }
}

